/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.oracle;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import net.automatalib.words.Word;

public class JointCounterOracle<I, D>
implements MembershipOracle<I, D> {
    private final MembershipOracle<I, D> delegate;
    private final AtomicLong queryCounter = new AtomicLong();
    private final AtomicLong symbolCounter = new AtomicLong();

    public JointCounterOracle(MembershipOracle<I, D> delegate) {
        this.delegate = delegate;
    }

    public void processQueries(Collection<? extends Query<I, D>> queries) {
        this.queryCounter.addAndGet(queries.size());
        for (Query<I, D> qry : queries) {
            this.symbolCounter.addAndGet(qry.getInput().length());
        }
        this.delegate.processQueries(queries);
    }

    public long getQueryCount() {
        return this.queryCounter.get();
    }

    public long getSymbolCount() {
        return this.symbolCounter.get();
    }

    public static class MealyJointCounterOracle<I, O>
    extends JointCounterOracle<I, Word<O>>
    implements MembershipOracle.MealyMembershipOracle<I, O> {
        public MealyJointCounterOracle(MembershipOracle<I, Word<O>> delegate) {
            super(delegate);
        }
    }

    public static class DFAJointCounterOracle<I>
    extends JointCounterOracle<I, Boolean>
    implements MembershipOracle.DFAMembershipOracle<I> {
        public DFAJointCounterOracle(MembershipOracle<I, Boolean> delegate) {
            super(delegate);
        }
    }
}

