/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracles;

import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.AbstractSingleQueryOracle;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Word;

public class SimulatorOracle<I, O>
extends AbstractSingleQueryOracle<I, O> {
    private final SuffixOutput<I, O> automaton;

    public SimulatorOracle(SuffixOutput<I, O> automaton) {
        this.automaton = automaton;
    }

    public O answerQuery(Word<I> prefix, Word<I> suffix) {
        return (O)this.automaton.computeSuffixOutput(prefix, suffix);
    }

    public static class MealySimulatorOracle<I, O>
    extends SimulatorOracle<I, Word<O>>
    implements MembershipOracle.MealyMembershipOracle<I, O> {
        public MealySimulatorOracle(MealyMachine<?, I, ?, O> mealy) {
            super(mealy);
        }
    }

    public static class DFASimulatorOracle<I>
    extends SimulatorOracle<I, Boolean>
    implements MembershipOracle.DFAMembershipOracle<I> {
        public DFASimulatorOracle(DFA<?, I> dfa) {
            super(dfa);
        }
    }
}

