/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.setting;

import de.learnlib.api.setting.LearnLibSettingsSource;
import java.util.Properties;
import net.automatalib.commons.util.settings.SettingsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LearnLibSettings {
    private static final Logger LOG = LoggerFactory.getLogger(LearnLibSettings.class);
    private static final LearnLibSettings INSTANCE = new LearnLibSettings();
    private final Properties properties = SettingsSource.readSettings(LearnLibSettingsSource.class);

    private LearnLibSettings() {
    }

    public static LearnLibSettings getInstance() {
        return INSTANCE;
    }

    public String getProperty(String propName, String defaultValue) {
        return this.properties.getProperty("learnlib." + propName, defaultValue);
    }

    public String getProperty(String propName) {
        return this.properties.getProperty("learnlib." + propName);
    }

    public <E extends Enum<E>> E getEnumValue(String propName, Class<E> enumClazz, E defaultValue) {
        E value = this.getEnumValue(propName, enumClazz);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public <E extends Enum<E>> E getEnumValue(String propName, Class<E> enumClazz) {
        String prop = this.getProperty(propName);
        if (prop == null) {
            return null;
        }
        return Enum.valueOf(enumClazz, prop.toUpperCase());
    }

    public boolean getBool(String propName, boolean defaultValue) {
        Boolean b = this.getBoolean(propName);
        if (b != null) {
            return b;
        }
        return defaultValue;
    }

    public Boolean getBoolean(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return null;
    }

    public int getInt(String propName, int defaultValue) {
        Integer prop = this.getInteger(propName);
        if (prop != null) {
            return prop;
        }
        return defaultValue;
    }

    public Integer getInteger(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Could not parse LearnLib integer property '" + propName + "'.", (Throwable)ex);
            }
        }
        return null;
    }
}

