/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.rpni;

import com.google.common.primitives.Ints;
import java.util.List;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.StateIDs;

final class EDSMUtil {
    private EDSMUtil() {
    }

    static <S> long score(UniversalDeterministicAutomaton<S, Integer, ?, Boolean, ?> pta, List<int[]> positiveSamples, List<int[]> negativeSamples) {
        int index;
        StateIDs stateIDs = pta.stateIDs();
        int[] tp = new int[pta.size()];
        int[] tn = new int[pta.size()];
        for (int[] w : positiveSamples) {
            int n = index = stateIDs.getStateId(pta.getState((Iterable)Ints.asList((int[])w)));
            tp[n] = tp[n] + 1;
        }
        for (int[] w : negativeSamples) {
            int n = index = stateIDs.getStateId(pta.getState((Iterable)Ints.asList((int[])w)));
            tn[n] = tn[n] + 1;
        }
        int score = 0;
        for (Object s : pta.getStates()) {
            int indexOfCurrentState = stateIDs.getStateId(s);
            if (tn[indexOfCurrentState] > 0) {
                if (tp[indexOfCurrentState] > 0) {
                    return Long.MIN_VALUE;
                }
                score += tn[indexOfCurrentState] - 1;
                continue;
            }
            if (tp[indexOfCurrentState] <= 0) continue;
            score += tp[indexOfCurrentState] - 1;
        }
        return score;
    }
}

