/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.rpni;

import de.learnlib.algorithms.rpni.BlueFringeRPNIDFA;
import de.learnlib.algorithms.rpni.EDSMUtil;
import de.learnlib.datastructure.pta.pta.AbstractBlueFringePTA;
import de.learnlib.datastructure.pta.pta.AbstractBlueFringePTAState;
import de.learnlib.datastructure.pta.pta.BlueFringePTA;
import de.learnlib.datastructure.pta.pta.BlueFringePTAState;
import de.learnlib.datastructure.pta.pta.PTATransition;
import de.learnlib.datastructure.pta.pta.RedBlueMerge;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.commons.util.Pair;
import net.automatalib.words.Alphabet;

public class BlueFringeEDSMDFA<I>
extends BlueFringeRPNIDFA<I> {
    public BlueFringeEDSMDFA(Alphabet<I> alphabet) {
        super(alphabet);
    }

    public DFA<?, I> computeModel() {
        BlueFringePTA pta = new BlueFringePTA(this.alphabetSize);
        this.initializePTA(pta);
        HashSet blue = new HashSet();
        pta.init(blue::add);
        while (!blue.isEmpty()) {
            boolean promotion = false;
            RedBlueMerge bestMerge = null;
            PTATransition bestTransition = null;
            long bestScore = Long.MIN_VALUE;
            Iterator blueIter = blue.iterator();
            while (blueIter.hasNext()) {
                Optional<Pair> result;
                PTATransition qbRef = (PTATransition)blueIter.next();
                BlueFringePTAState qb = (BlueFringePTAState)qbRef.getTarget();
                Stream stream = pta.redStatesStream();
                if (this.parallel) {
                    stream = (Stream)stream.parallel();
                }
                if ((result = stream.map(qr -> this.tryMerge(pta, (BlueFringePTAState)qr, qb)).filter(Objects::nonNull).map(merge -> new Pair(merge, (Object)EDSMUtil.score(merge.toMergedAutomaton(), this.positive, this.negative))).max(Comparator.comparingLong(Pair::getSecond))).isPresent()) {
                    Pair mergeResult = result.get();
                    if ((Long)mergeResult.getSecond() <= bestScore) continue;
                    bestMerge = (RedBlueMerge)mergeResult.getFirst();
                    bestTransition = qbRef;
                    continue;
                }
                promotion = true;
                blueIter.remove();
                pta.promote((AbstractBlueFringePTAState)qb, blue::add);
                break;
            }
            if (promotion) continue;
            blue.remove(bestTransition);
            bestMerge.apply((AbstractBlueFringePTA)pta, blue::add);
        }
        return this.ptaToModel(pta);
    }
}

