/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.reuse.tree;

import de.learnlib.filter.reuse.ReuseCapableOracle;
import de.learnlib.filter.reuse.ReuseException;
import de.learnlib.filter.reuse.tree.BoundedDeque;
import de.learnlib.filter.reuse.tree.ReuseEdge;
import de.learnlib.filter.reuse.tree.ReuseNode;
import de.learnlib.filter.reuse.tree.ReuseTreeDotHelper;
import de.learnlib.filter.reuse.tree.SystemStateHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.graph.Graph;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ReuseTree<S, I, O>
implements Graph<ReuseNode<S, I, O>, ReuseEdge<S, I, O>> {
    private final Alphabet<I> alphabet;
    private final int alphabetSize;
    private final Set<I> invariantInputSymbols;
    private final Set<O> failureOutputSymbols;
    private final boolean invalidateSystemStates;
    private final SystemStateHandler<S> systemStateHandler;
    private final int maxSystemStates;
    private final BoundedDeque.AccessPolicy accessPolicy;
    private final BoundedDeque.EvictPolicy evictPolicy;
    private int nodeCount;
    private ReuseNode<S, I, O> root;
    private final ReadWriteLock lock;

    public ReuseTree(Alphabet<I> alphabet, boolean enabledSystemStateInvalidation, SystemStateHandler<S> systemStateHandler, Set<I> invariantInputs, Set<O> failureOutputs, int maxSystemStates, BoundedDeque.AccessPolicy accessPolicy, BoundedDeque.EvictPolicy evictPolicy) {
        this.alphabet = alphabet;
        this.invalidateSystemStates = enabledSystemStateInvalidation;
        this.systemStateHandler = systemStateHandler;
        this.invariantInputSymbols = invariantInputs;
        this.failureOutputSymbols = failureOutputs;
        this.maxSystemStates = maxSystemStates;
        this.accessPolicy = accessPolicy;
        this.evictPolicy = evictPolicy;
        this.alphabetSize = alphabet.size();
        this.root = new ReuseNode(this.nodeCount++, this.alphabetSize, maxSystemStates, accessPolicy, evictPolicy);
        this.lock = new ReentrantReadWriteLock();
    }

    private ReuseNode<S, I, O> createNode() {
        return new ReuseNode(this.nodeCount++, this.alphabetSize, this.maxSystemStates, this.accessPolicy, this.evictPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Word<O> getOutput(Word<I> query) {
        WordBuilder output = new WordBuilder();
        this.lock.readLock().lock();
        try {
            ReuseNode<S, I, O> sink = this.getRoot();
            for (Object symbol : query) {
                ReuseEdge<S, I, O> edge = sink.getEdgeWithInput(this.alphabet.getSymbolIndex(symbol));
                if (edge == null) {
                    Word<O> word = null;
                    return word;
                }
                output.add(edge.getOutput());
                sink = edge.getTarget();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return output.toWord();
    }

    public ReuseNode<S, I, O> getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public Word<@Nullable O> getPartialOutput(Word<I> query) {
        @Nullable WordBuilder output = new WordBuilder();
        this.lock.readLock().lock();
        try {
            ReuseNode<S, I, O> sink = this.getRoot();
            for (Object symbol : query) {
                ReuseEdge<S, I, O> edge = sink.getEdgeWithInput(this.alphabet.getSymbolIndex(symbol));
                if (edge == null) {
                    break;
                }
                if (sink.equals(edge.getTarget())) {
                    output.add(edge.getOutput());
                } else {
                    output.add(null);
                }
                sink = edge.getTarget();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        output.repeatAppend(query.size() - output.size(), null);
        return output.toWord();
    }

    public void disposeSystemStates() {
        this.lock.writeLock().lock();
        try {
            this.disposeSystemStates(this.getRoot());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void disposeSystemStates(ReuseNode<S, I, O> node) {
        Iterator<S> stateIt = node.systemStatesIterator();
        while (stateIt.hasNext()) {
            S state = stateIt.next();
            this.systemStateHandler.dispose(state);
        }
        node.clearSystemStates();
        for (ReuseEdge<S, I, O> edge : node.getEdges()) {
            if (edge == null || edge.getTarget().equals(node)) continue;
            this.disposeSystemStates(edge.getTarget());
        }
    }

    public void clearTree() {
        this.lock.writeLock().lock();
        try {
            this.nodeCount = 0;
            this.disposeSystemStates(this.root);
            this.root = this.createNode();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ReuseNode.NodeResult<S, I, O> fetchSystemState(Word<I> query) {
        int length = 0;
        this.lock.readLock().lock();
        try {
            ReuseNode<S, I, O> node;
            ReuseNode<S, I, O> sink = this.getRoot();
            ReuseNode<S, I, O> lastState = null;
            if (sink.hasSystemStates()) {
                lastState = sink;
            }
            for (int i = 0; i < query.size() && (node = sink.getTargetNodeForInput(this.alphabet.getSymbolIndex(query.getSymbol(i)))) != null; ++i) {
                sink = node;
                if (!sink.hasSystemStates()) continue;
                lastState = sink;
                length = i + 1;
            }
            if (lastState == null) {
                ReuseNode.NodeResult<S, I, O> i = null;
                return i;
            }
            S systemState = lastState.fetchSystemState(this.invalidateSystemStates);
            assert (systemState != null);
            ReuseNode.NodeResult<S, I, O> nodeResult = new ReuseNode.NodeResult<S, I, O>(lastState, systemState, length);
            return nodeResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void insert(Word<I> query, ReuseCapableOracle.QueryResult<S, O> queryResult) {
        this.insert(query, this.getRoot(), queryResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Word<I> query, ReuseNode<S, I, O> sink, ReuseCapableOracle.QueryResult<S, O> queryResult) {
        if (query.size() != queryResult.output.size()) {
            String msg = "Size mismatch: " + query + "/" + queryResult.output;
            throw new IllegalArgumentException(msg);
        }
        ReuseNode effectiveSink = sink;
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < query.size(); ++i) {
                Object in = query.getSymbol(i);
                Object out = queryResult.output.getSymbol(i);
                ReuseEdge<S, I, O> edge = effectiveSink.getEdgeWithInput(this.alphabet.getSymbolIndex(in));
                if (edge != null) {
                    if (Objects.equals(edge.getOutput(), out)) {
                        effectiveSink = edge.getTarget();
                        continue;
                    }
                    throw new ReuseException("Conflict: input '" + query + "', output '" + queryResult.output + "', i=" + i + ", cached output '" + edge.getOutput() + "'");
                }
                ReuseNode rn = this.failureOutputSymbols.contains(out) ? effectiveSink : (this.invariantInputSymbols.contains(in) ? effectiveSink : this.createNode());
                int index = this.alphabet.getSymbolIndex(in);
                effectiveSink.addEdge(index, new ReuseEdge<S, Object, Object>(effectiveSink, rn, in, out));
                effectiveSink = rn;
            }
            S evictedState = effectiveSink.addSystemState(queryResult.newState);
            if (evictedState != null) {
                this.systemStateHandler.dispose(evictedState);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Collection<ReuseNode<S, I, O>> getNodes() {
        ArrayList<ReuseNode<S, I, O>> collection = new ArrayList<ReuseNode<S, I, O>>();
        this.appendNodesRecursively(collection, this.getRoot());
        return collection;
    }

    private void appendNodesRecursively(Collection<ReuseNode<S, I, O>> nodes, ReuseNode<S, I, O> current) {
        nodes.add(current);
        for (int i = 0; i < this.alphabetSize; ++i) {
            ReuseEdge<S, I, O> reuseEdge = current.getEdgeWithInput(i);
            if (reuseEdge == null || current.equals(reuseEdge.getTarget())) continue;
            this.appendNodesRecursively(nodes, reuseEdge.getTarget());
        }
    }

    public Collection<ReuseEdge<S, I, O>> getOutgoingEdges(ReuseNode<S, I, O> node) {
        return node.getEdges();
    }

    public ReuseNode<S, I, O> getTarget(ReuseEdge<S, I, O> edge) {
        return edge.getTarget();
    }

    public VisualizationHelper<ReuseNode<S, I, O>, ReuseEdge<S, I, O>> getVisualizationHelper() {
        return new ReuseTreeDotHelper();
    }
}

