/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.reuse;

import de.learnlib.filter.reuse.ReuseCapableOracle;
import de.learnlib.filter.reuse.tree.BoundedDeque;
import de.learnlib.filter.reuse.tree.ReuseNode;
import de.learnlib.filter.reuse.tree.ReuseTree;
import de.learnlib.filter.reuse.tree.SystemStateHandler;
import de.learnlib.oracle.SingleQueryOracle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ReuseOracle<S, I, O>
implements SingleQueryOracle.SingleQueryOracleMealy<I, O> {
    private final ThreadLocal<ReuseCapableOracle<S, I, O>> executableOracles;
    private final ReuseTree<S, I, O> tree;

    public ReuseOracle(Alphabet<I> alphabet, Supplier<? extends ReuseCapableOracle<S, I, O>> oracleSupplier, boolean enabledSystemStateInvalidation, SystemStateHandler<S> systemStateHandler, Set<I> invariantInputs, Set<O> failureOutputs, int maxSystemStates, BoundedDeque.AccessPolicy accessPolicy, BoundedDeque.EvictPolicy evictPolicy) {
        this.executableOracles = ThreadLocal.withInitial(oracleSupplier);
        this.tree = new ReuseTree<S, I, O>(alphabet, enabledSystemStateInvalidation, systemStateHandler, invariantInputs, failureOutputs, maxSystemStates, accessPolicy, evictPolicy);
    }

    public Word<O> answerQuery(Word<I> prefix, Word<I> suffix) {
        return this.processQuery(prefix.concat(new Word[]{suffix})).suffix(suffix.length());
    }

    public Word<O> answerQuery(Word<I> input) {
        return this.processQuery(input);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Word<O> processQuery(Word<I> query) {
        Word output;
        Word<O> knownOutput = this.tree.getOutput(query);
        if (knownOutput != null) {
            return knownOutput;
        }
        ReuseNode.NodeResult<S, I, O> nodeResult = this.tree.fetchSystemState(query);
        ReuseCapableOracle oracle = this.getReuseCapableOracle();
        if (nodeResult == null) {
            ReuseCapableOracle.QueryResult<S, O> newResult = this.filterAndProcessQuery(query, this.tree.getPartialOutput(query), oracle::processQuery);
            this.tree.insert(query, newResult);
            output = newResult.output;
        } else {
            int suffixLen = query.size() - nodeResult.prefixLength;
            Word suffix = query.suffix(suffixLen);
            Word<@Nullable O> partialOutput = this.tree.getPartialOutput(query);
            @Nullable Word partialSuffixOutput = partialOutput.suffix(suffixLen);
            ReuseNode reuseNode = nodeResult.reuseNode;
            Object systemState = nodeResult.systemState;
            ReuseCapableOracle.QueryResult<S, O> suffixQueryResult = this.filterAndProcessQuery(suffix, partialSuffixOutput, filteredInput -> oracle.continueQuery((Word)filteredInput, systemState));
            this.tree.insert(suffix, reuseNode, suffixQueryResult);
            Word<O> prefixOutput = this.tree.getOutput(query.prefix(nodeResult.prefixLength));
            assert (prefixOutput != null);
            output = new WordBuilder(prefixOutput).append(suffixQueryResult.output).toWord();
        }
        return output;
    }

    public ReuseCapableOracle<S, I, O> getReuseCapableOracle() {
        return this.executableOracles.get();
    }

    private ReuseCapableOracle.QueryResult<S, O> filterAndProcessQuery(Word<I> query, Word<@Nullable O> partialOutput, Function<Word<I>, ReuseCapableOracle.QueryResult<S, O>> processQuery) {
        LinkedList filteredQueryList = new LinkedList(query.asList());
        Iterator queryIterator = filteredQueryList.iterator();
        for (Object outputSymbol : partialOutput) {
            queryIterator.next();
            if (outputSymbol == null) continue;
            queryIterator.remove();
        }
        ReuseCapableOracle.QueryResult<S, O> res = processQuery.apply(Word.fromList(filteredQueryList));
        WordBuilder wordBuilder = new WordBuilder();
        Iterator resultIterator = res.output.iterator();
        for (Object output : partialOutput) {
            if (output == null) {
                wordBuilder.add(resultIterator.next());
                continue;
            }
            wordBuilder.add(output);
        }
        return new ReuseCapableOracle.QueryResult(wordBuilder.toWord(), res.newState);
    }

    public ReuseTree<S, I, O> getReuseTree() {
        return this.tree;
    }
}

