/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.reuse.tree;

import de.learnlib.filter.reuse.tree.ReuseEdge;
import de.learnlib.filter.reuse.tree.ReuseNode;
import java.util.Map;
import net.automatalib.visualization.DefaultVisualizationHelper;

class ReuseTreeDotHelper<S, I, O>
extends DefaultVisualizationHelper<ReuseNode<S, I, O>, ReuseEdge<S, I, O>> {
    ReuseTreeDotHelper() {
    }

    public boolean getNodeProperties(ReuseNode<S, I, O> node, Map<String, String> properties) {
        super.getNodeProperties(node, properties);
        if (node.hasSystemStates()) {
            properties.put("color", "black");
            properties.put("style", "filled");
            properties.put("shape", "diamond");
            properties.put("fontcolor", "white");
        }
        properties.put("label", "");
        return true;
    }

    public boolean getEdgeProperties(ReuseNode<S, I, O> src, ReuseEdge<S, I, O> edge, ReuseNode<S, I, O> tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(String.valueOf(edge.getInput())).append(" / ");
        O output = edge.getOutput();
        if (output != null) {
            labelBuilder.append(String.valueOf(output));
        }
        properties.put("label", labelBuilder.toString());
        return true;
    }
}

