/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.reuse.tree;

import de.learnlib.filter.reuse.ReuseCapableOracle;
import de.learnlib.filter.reuse.ReuseException;
import de.learnlib.filter.reuse.tree.BoundedDeque;
import de.learnlib.filter.reuse.tree.ReuseEdge;
import de.learnlib.filter.reuse.tree.ReuseNode;
import de.learnlib.filter.reuse.tree.ReuseTreeDotHelper;
import de.learnlib.filter.reuse.tree.SystemStateHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.automatalib.graphs.Graph;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public final class ReuseTree<S, I, O>
implements Graph<ReuseNode<S, I, O>, ReuseEdge<S, I, O>> {
    private final Alphabet<I> alphabet;
    private final int alphabetSize;
    private final Set<I> invariantInputSymbols;
    private final Set<O> failureOutputSymbols;
    private final boolean invalidateSystemstates;
    private final SystemStateHandler<S> systemStateHandler;
    private final int maxSystemStates;
    private final BoundedDeque.AccessPolicy accessPolicy;
    private final BoundedDeque.EvictPolicy evictPolicy;
    private int nodeCount;
    private ReuseNode<S, I, O> root;

    private ReuseTree(ReuseTreeBuilder<S, I, O> builder) {
        this.alphabet = ((ReuseTreeBuilder)builder).alphabet;
        this.invalidateSystemstates = ((ReuseTreeBuilder)builder).invalidateSystemstates;
        SystemStateHandler<Object> handler = ((ReuseTreeBuilder)builder).systemStateHandler;
        if (handler == null) {
            handler = state -> {};
        }
        this.systemStateHandler = handler;
        this.invariantInputSymbols = ((ReuseTreeBuilder)builder).invariantInputSymbols != null ? ((ReuseTreeBuilder)builder).invariantInputSymbols : Collections.emptySet();
        this.failureOutputSymbols = ((ReuseTreeBuilder)builder).failureOutputSymbols != null ? ((ReuseTreeBuilder)builder).failureOutputSymbols : Collections.emptySet();
        this.maxSystemStates = ((ReuseTreeBuilder)builder).maxSystemStates;
        this.accessPolicy = ((ReuseTreeBuilder)builder).accessPolicy;
        this.evictPolicy = ((ReuseTreeBuilder)builder).evictPolicy;
        this.alphabetSize = this.alphabet.size();
        this.root = this.createNode();
    }

    private ReuseNode<S, I, O> createNode() {
        return new ReuseNode(this.nodeCount++, this.alphabetSize, this.maxSystemStates, this.accessPolicy, this.evictPolicy);
    }

    public synchronized Word<O> getOutput(Word<I> query) {
        if (query == null) {
            String msg = "Query is not allowed to be null.";
            throw new IllegalArgumentException(msg);
        }
        WordBuilder output = new WordBuilder();
        ReuseNode<S, I, O> sink = this.getRoot();
        for (Object symbol : query) {
            ReuseEdge<S, I, O> edge = sink.getEdgeWithInput(this.alphabet.getSymbolIndex(symbol));
            if (edge == null) {
                return null;
            }
            output.add(edge.getOutput());
            sink = edge.getTarget();
        }
        return output.toWord();
    }

    public ReuseNode<S, I, O> getRoot() {
        return this.root;
    }

    public synchronized Word<O> getPartialOutput(Word<I> query) {
        Object symbol;
        ReuseEdge<S, I, O> edge;
        if (query == null) {
            String msg = "Query is not allowed to be null.";
            throw new IllegalArgumentException(msg);
        }
        WordBuilder output = new WordBuilder();
        ReuseNode<S, I, O> sink = this.getRoot();
        Iterator iterator = query.iterator();
        while (iterator.hasNext() && (edge = sink.getEdgeWithInput(this.alphabet.getSymbolIndex(symbol = iterator.next()))) != null) {
            if (sink.equals(edge.getTarget())) {
                output.add(edge.getOutput());
            } else {
                output.add(null);
            }
            sink = edge.getTarget();
        }
        output.repeatAppend(query.size() - output.size(), null);
        return output.toWord();
    }

    public synchronized void disposeSystemstates() {
        this.disposeSystemstates(this.getRoot());
    }

    private void disposeSystemstates(ReuseNode<S, I, O> node) {
        Iterator<S> stateIt = node.systemStatesIterator();
        while (stateIt.hasNext()) {
            S state = stateIt.next();
            this.systemStateHandler.dispose(state);
        }
        node.clearSystemStates();
        for (ReuseEdge<S, I, O> edge : node.getEdges()) {
            if (edge == null || edge.getTarget().equals(node)) continue;
            this.disposeSystemstates(edge.getTarget());
        }
    }

    public synchronized void clearTree() {
        this.nodeCount = 0;
        this.disposeSystemstates(this.root);
        this.root = this.createNode();
    }

    public synchronized ReuseNode.NodeResult<S, I, O> fetchSystemState(Word<I> query) {
        ReuseNode<S, I, O> node;
        if (query == null) {
            String msg = "Query is not allowed to be null.";
            throw new IllegalArgumentException(msg);
        }
        int length = 0;
        ReuseNode<S, I, O> sink = this.getRoot();
        ReuseNode<S, I, O> lastState = null;
        if (sink.hasSystemStates()) {
            lastState = sink;
        }
        for (int i = 0; i < query.size() && (node = sink.getTargetNodeForInput(this.alphabet.getSymbolIndex(query.getSymbol(i)))) != null; ++i) {
            sink = node;
            if (!sink.hasSystemStates()) continue;
            lastState = sink;
            length = i + 1;
        }
        if (lastState == null) {
            return null;
        }
        S systemState = lastState.fetchSystemState(this.invalidateSystemstates);
        return new ReuseNode.NodeResult<S, I, O>(lastState, systemState, length);
    }

    public synchronized void insert(Word<I> query, ReuseCapableOracle.QueryResult<S, O> queryResult) {
        this.insert(query, this.getRoot(), queryResult);
    }

    public synchronized void insert(Word<I> query, ReuseNode<S, I, O> sink, ReuseCapableOracle.QueryResult<S, O> queryResult) {
        if (queryResult == null) {
            String msg = "The queryResult is not allowed to be null.";
            throw new IllegalArgumentException(msg);
        }
        if (sink == null) {
            String msg = "Node is not allowed to be null, called wrong method?";
            throw new IllegalArgumentException(msg);
        }
        if (query.size() != queryResult.output.size()) {
            String msg = "Size mismatch: " + query + "/" + queryResult.output;
            throw new IllegalArgumentException(msg);
        }
        ReuseNode effectiveSink = sink;
        for (int i = 0; i < query.size(); ++i) {
            Object in = query.getSymbol(i);
            Object out = queryResult.output.getSymbol(i);
            ReuseEdge<S, I, O> edge = effectiveSink.getEdgeWithInput(this.alphabet.getSymbolIndex(in));
            if (edge != null) {
                if (Objects.equals(edge.getOutput(), out)) {
                    effectiveSink = edge.getTarget();
                    continue;
                }
                throw new ReuseException("Conflict: input '" + query + "', output '" + queryResult.output + "', i=" + i + ", cached output '" + edge.getOutput() + "'");
            }
            ReuseNode rn = this.failureOutputSymbols.contains(out) ? effectiveSink : (this.invariantInputSymbols.contains(in) ? effectiveSink : this.createNode());
            int index = this.alphabet.getSymbolIndex(in);
            effectiveSink.addEdge(index, new ReuseEdge<S, Object, Object>(effectiveSink, rn, in, out));
            effectiveSink = rn;
        }
        S evictedState = effectiveSink.addSystemState(queryResult.newState);
        if (evictedState != null) {
            this.systemStateHandler.dispose(evictedState);
        }
    }

    public Collection<ReuseNode<S, I, O>> getNodes() {
        ArrayList<ReuseNode<S, I, O>> collection = new ArrayList<ReuseNode<S, I, O>>();
        this.appendNodesRecursively(collection, this.getRoot());
        return collection;
    }

    private void appendNodesRecursively(Collection<ReuseNode<S, I, O>> nodes, ReuseNode<S, I, O> current) {
        nodes.add(current);
        for (int i = 0; i < this.alphabetSize; ++i) {
            ReuseEdge<S, I, O> reuseEdge = current.getEdgeWithInput(i);
            if (reuseEdge == null || current.equals(reuseEdge.getTarget())) continue;
            this.appendNodesRecursively(nodes, reuseEdge.getTarget());
        }
    }

    public synchronized Collection<ReuseEdge<S, I, O>> getOutgoingEdges(ReuseNode<S, I, O> node) {
        return node.getEdges();
    }

    public synchronized ReuseNode<S, I, O> getTarget(ReuseEdge<S, I, O> edge) {
        if (edge != null) {
            return edge.getTarget();
        }
        return null;
    }

    public synchronized VisualizationHelper<ReuseNode<S, I, O>, ReuseEdge<S, I, O>> getVisualizationHelper() {
        return new ReuseTreeDotHelper();
    }

    public static class ReuseTreeBuilder<S, I, O> {
        private final Alphabet<I> alphabet;
        private boolean invalidateSystemstates = true;
        private SystemStateHandler<S> systemStateHandler;
        private Set<I> invariantInputSymbols;
        private Set<O> failureOutputSymbols;
        private int maxSystemStates = -1;
        private BoundedDeque.AccessPolicy accessPolicy = BoundedDeque.AccessPolicy.LIFO;
        private BoundedDeque.EvictPolicy evictPolicy = BoundedDeque.EvictPolicy.EVICT_OLDEST;

        public ReuseTreeBuilder(Alphabet<I> alphabet) {
            this.alphabet = alphabet;
            this.systemStateHandler = null;
            this.invariantInputSymbols = Collections.emptySet();
            this.failureOutputSymbols = Collections.emptySet();
        }

        public ReuseTreeBuilder<S, I, O> withSystemStateHandler(SystemStateHandler<S> systemStateHandler) {
            this.systemStateHandler = systemStateHandler;
            return this;
        }

        public ReuseTreeBuilder<S, I, O> withEnabledSystemstateInvalidation(boolean invalidate) {
            this.invalidateSystemstates = invalidate;
            return this;
        }

        public ReuseTreeBuilder<S, I, O> withInvariantInputs(Set<I> inputs) {
            this.invariantInputSymbols = inputs;
            return this;
        }

        public ReuseTreeBuilder<S, I, O> withFailureOutputs(Set<O> outputs) {
            this.failureOutputSymbols = outputs;
            return this;
        }

        public ReuseTreeBuilder<S, I, O> withMaxSystemStates(int maxSystemStates) {
            this.maxSystemStates = maxSystemStates;
            return this;
        }

        public ReuseTreeBuilder<S, I, O> withAccessPolicy(BoundedDeque.AccessPolicy accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public ReuseTreeBuilder<S, I, O> withEvictPolicy(BoundedDeque.EvictPolicy evictPolicy) {
            this.evictPolicy = evictPolicy;
            return this;
        }

        public ReuseTree<S, I, O> build() {
            return new ReuseTree(this);
        }
    }
}

