/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filters.reuse;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.filters.reuse.ReuseCapableOracle;
import de.learnlib.filters.reuse.tree.BoundedDeque;
import de.learnlib.filters.reuse.tree.ReuseNode;
import de.learnlib.filters.reuse.tree.ReuseTree;
import de.learnlib.filters.reuse.tree.SystemStateHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class ReuseOracle<S, I, O>
implements MembershipOracle.MealyMembershipOracle<I, O> {
    private final Supplier<? extends ReuseCapableOracle<S, I, O>> oracleSupplier;
    private final ThreadLocal<ReuseCapableOracle<S, I, O>> executableOracles = new ThreadLocal<ReuseCapableOracle<S, I, O>>(){

        @Override
        protected ReuseCapableOracle<S, I, O> initialValue() {
            return (ReuseCapableOracle)ReuseOracle.this.oracleSupplier.get();
        }
    };
    private final ReuseTree<S, I, O> tree;

    private ReuseOracle(ReuseOracleBuilder<S, I, O> builder) {
        this.oracleSupplier = ((ReuseOracleBuilder)builder).oracleSupplier;
        this.tree = new ReuseTree.ReuseTreeBuilder(((ReuseOracleBuilder)builder).alphabet).withSystemStateHandler(((ReuseOracleBuilder)builder).systemStateHandler).withFailureOutputs(((ReuseOracleBuilder)builder).failureOutputSymbols).withInvariantInputs(((ReuseOracleBuilder)builder).invariantInputSymbols).withEnabledSystemstateInvalidation(((ReuseOracleBuilder)builder).invalidateSystemstates).withMaxSystemStates(((ReuseOracleBuilder)builder).maxSystemStates).withAccessPolicy(((ReuseOracleBuilder)builder).accessPolicy).withEvictPolicy(((ReuseOracleBuilder)builder).evictPolicy).build();
    }

    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        for (Query<I, Word<O>> query : queries) {
            Word<O> output = this.processQuery(query.getInput());
            query.answer((Object)output.suffix(query.getSuffix().size()));
        }
    }

    private Word<O> processQuery(Word<I> query) {
        Word output;
        Word<O> knownOutput = this.tree.getOutput(query);
        if (knownOutput != null) {
            return knownOutput;
        }
        ReuseNode.NodeResult<S, I, O> nodeResult = this.tree.fetchSystemState(query);
        final ReuseCapableOracle<S, I, O> oracle = this.getReuseCapableOracle();
        if (nodeResult == null) {
            ReuseCapableOracle.QueryResult<S, O> newResult = this.filterAndProcessQuery(query, this.tree.getPartialOutput(query), new Function<Word<I>, ReuseCapableOracle.QueryResult<S, O>>(){

                public ReuseCapableOracle.QueryResult<S, O> apply(Word<I> filteredInput) {
                    return oracle.processQuery(filteredInput);
                }
            });
            this.tree.insert(query, newResult);
            output = newResult.output;
        } else {
            int suffixLen = query.size() - nodeResult.prefixLength;
            Word suffix = query.suffix(suffixLen);
            Word<O> partialOutput = this.tree.getPartialOutput(query);
            Word partialSuffixOutput = partialOutput.suffix(suffixLen);
            ReuseNode reuseNode = nodeResult.reuseNode;
            final Object systemState = nodeResult.systemState;
            ReuseCapableOracle.QueryResult<S, O> suffixQueryResult = this.filterAndProcessQuery(suffix, partialSuffixOutput, new Function<Word<I>, ReuseCapableOracle.QueryResult<S, O>>(){

                public ReuseCapableOracle.QueryResult<S, O> apply(Word<I> filteredInput) {
                    return oracle.continueQuery(filteredInput, systemState);
                }
            });
            this.tree.insert(suffix, reuseNode, suffixQueryResult);
            Word<O> prefixOutput = this.tree.getOutput(query.prefix(nodeResult.prefixLength));
            output = new WordBuilder(prefixOutput).append(suffixQueryResult.output).toWord();
        }
        return output;
    }

    private ReuseCapableOracle.QueryResult<S, O> filterAndProcessQuery(Word<I> query, Word<O> partialOutput, Function<Word<I>, ReuseCapableOracle.QueryResult<S, O>> processQuery) {
        LinkedList filteredQueryList = new LinkedList(query.asList());
        Iterator queryIterator = filteredQueryList.iterator();
        for (Object outputSymbol : partialOutput) {
            queryIterator.next();
            if (outputSymbol == null) continue;
            queryIterator.remove();
        }
        ReuseCapableOracle.QueryResult res = (ReuseCapableOracle.QueryResult)processQuery.apply((Object)Word.fromList(filteredQueryList));
        WordBuilder wordBuilder = new WordBuilder();
        Iterator resultIterator = res.output.iterator();
        for (Object output : partialOutput) {
            if (output == null) {
                wordBuilder.add(resultIterator.next());
                continue;
            }
            wordBuilder.add(output);
        }
        return new ReuseCapableOracle.QueryResult(wordBuilder.toWord(), res.newState);
    }

    public ReuseTree<S, I, O> getReuseTree() {
        return this.tree;
    }

    public ReuseCapableOracle<S, I, O> getReuseCapableOracle() {
        return this.executableOracles.get();
    }

    public static class ReuseOracleBuilder<S, I, O> {
        private final Alphabet<I> alphabet;
        private final Supplier<? extends ReuseCapableOracle<S, I, O>> oracleSupplier;
        private boolean invalidateSystemstates = true;
        private SystemStateHandler<S> systemStateHandler;
        private Set<I> invariantInputSymbols;
        private Set<O> failureOutputSymbols;
        private int maxSystemStates = -1;
        private BoundedDeque.AccessPolicy accessPolicy = BoundedDeque.AccessPolicy.LIFO;
        private BoundedDeque.EvictPolicy evictPolicy = BoundedDeque.EvictPolicy.EVICT_OLDEST;

        public ReuseOracleBuilder(Alphabet<I> alphabet, Supplier<? extends ReuseCapableOracle<S, I, O>> oracleSupplier) {
            this.alphabet = alphabet;
            this.oracleSupplier = oracleSupplier;
        }

        public ReuseOracleBuilder<S, I, O> withSystemStateHandler(SystemStateHandler<S> systemStateHandler) {
            this.systemStateHandler = systemStateHandler;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withEnabledSystemstateInvalidation(boolean invalidate) {
            this.invalidateSystemstates = invalidate;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withInvariantInputs(Set<I> inputs) {
            this.invariantInputSymbols = inputs;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withFailureOutputs(Set<O> outputs) {
            this.failureOutputSymbols = outputs;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withMaxSystemStates(int maxSystemStates) {
            this.maxSystemStates = maxSystemStates;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withAccessPolicy(BoundedDeque.AccessPolicy accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withEvictPolicy(BoundedDeque.EvictPolicy evictPolicy) {
            this.evictPolicy = evictPolicy;
            return this;
        }

        public ReuseOracle<S, I, O> build() {
            return new ReuseOracle(this);
        }
    }
}

