/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filters.reuse.tree;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class BoundedDeque<E>
extends AbstractCollection<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EvictPolicy evictPolicy;
    private final AccessPolicy accessPolicy;
    private final int capacity;
    private final Deque<E> deque;

    public BoundedDeque(AccessPolicy accessPolicy) {
        this(-1, accessPolicy, EvictPolicy.EVICT_OLDEST);
    }

    public BoundedDeque(int capacity, AccessPolicy accessPolicy, EvictPolicy evictPolicy) {
        this.deque = capacity <= 0 ? new ArrayDeque() : new ArrayDeque(capacity);
        this.capacity = capacity;
        this.accessPolicy = accessPolicy;
        this.evictPolicy = evictPolicy;
    }

    public E insert(E element) {
        E evicted = null;
        if (this.size() >= this.capacity) {
            if (this.evictPolicy == EvictPolicy.REJECT_NEW) {
                return element;
            }
            evicted = this.evict();
        }
        this.deque.offerLast(element);
        return evicted;
    }

    public E retrieve() {
        switch (this.accessPolicy) {
            case LIFO: {
                return this.deque.pollLast();
            }
            case FIFO: {
                return this.deque.pollFirst();
            }
        }
        throw new IllegalStateException("Illegal access policy: " + (Object)((Object)this.accessPolicy));
    }

    public E peek() {
        switch (this.accessPolicy) {
            case LIFO: {
                return this.deque.peekLast();
            }
            case FIFO: {
                return this.deque.peekFirst();
            }
        }
        throw new IllegalStateException("Illegal access policy: " + (Object)((Object)this.accessPolicy));
    }

    public boolean isBounded() {
        return this.capacity > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public void clear() {
        this.deque.clear();
    }

    private E evict() {
        switch (this.evictPolicy) {
            case EVICT_OLDEST: {
                return this.deque.pollFirst();
            }
            case EVICT_NEWEST: {
                return this.deque.pollLast();
            }
        }
        throw new IllegalStateException("Illegal evict policy: " + (Object)((Object)this.evictPolicy));
    }

    @Override
    public Iterator<E> iterator() {
        return this.deque.iterator();
    }

    public static enum EvictPolicy {
        EVICT_OLDEST,
        REJECT_NEW,
        EVICT_NEWEST;

    }

    public static enum AccessPolicy {
        LIFO,
        FIFO;

    }
}

