/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.property;

import de.learnlib.oracle.PropertyOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.automatalib.automaton.concept.Output;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PropertyOracleChain<I, A extends Output<I, D>, @Nullable P, D>
implements PropertyOracle<I, A, P, D> {
    private final P property;
    private @Nullable DefaultQuery<I, D> counterExample;
    private final List<PropertyOracle<I, ? super A, P, D>> oracles;

    @SafeVarargs
    public PropertyOracleChain(PropertyOracle<I, ? super A, P, D> ... oracles) {
        this(Arrays.asList(oracles));
    }

    public PropertyOracleChain(Collection<? extends PropertyOracle<I, ? super A, P, D>> oracles) {
        this.oracles = new ArrayList<PropertyOracle<I, A, P, D>>(oracles);
        this.property = this.oracles.isEmpty() ? null : this.oracles.get(0).getProperty();
    }

    public @Nullable DefaultQuery<I, D> doFindCounterExample(A hypothesis, Collection<? extends I> inputs) {
        for (PropertyOracle<I, ? super A, P, D> propertyOracle : this.oracles) {
            DefaultQuery ceQry = propertyOracle.findCounterExample(hypothesis, inputs);
            if (ceQry == null) continue;
            return ceQry;
        }
        return null;
    }

    public @Nullable DefaultQuery<I, D> disprove(A hypothesis, Collection<? extends I> inputs) {
        for (PropertyOracle<I, ? super A, P, D> propertyOracle : this.oracles) {
            DefaultQuery ceQry = propertyOracle.disprove(hypothesis, inputs);
            if (ceQry == null) continue;
            this.counterExample = ceQry;
            return ceQry;
        }
        return null;
    }

    public P getProperty() {
        return this.property;
    }

    public @Nullable DefaultQuery<I, D> getCounterExample() {
        return this.counterExample;
    }
}

