/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.property;

import de.learnlib.logging.Category;
import de.learnlib.oracle.PropertyOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.automaton.concept.Output;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPropertyOracle<I, A extends Output<I, D>, P, D>
implements PropertyOracle<I, A, P, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingPropertyOracle.class);
    private final PropertyOracle<I, A, P, D> propertyOracle;

    public LoggingPropertyOracle(PropertyOracle<I, A, P, D> propertyOracle) {
        this.propertyOracle = propertyOracle;
    }

    public boolean isDisproved() {
        return this.propertyOracle.isDisproved();
    }

    public P getProperty() {
        return (P)this.propertyOracle.getProperty();
    }

    public @Nullable DefaultQuery<I, D> getCounterExample() {
        return this.propertyOracle.getCounterExample();
    }

    public @Nullable DefaultQuery<I, D> disprove(A hypothesis, Collection<? extends I> inputs) {
        DefaultQuery result = this.propertyOracle.disprove(hypothesis, inputs);
        if (result != null) {
            LOGGER.info(Category.EVENT, "Property violated: '{}'", (Object)this);
            LOGGER.info(Category.QUERY, "Counter example for property: {}", this.getCounterExample());
        }
        return result;
    }

    public @Nullable DefaultQuery<I, D> doFindCounterExample(A hypothesis, Collection<? extends I> inputs) {
        DefaultQuery result = this.propertyOracle.findCounterExample(hypothesis, inputs);
        if (result != null) {
            LOGGER.info(Category.EVENT, "Spurious counterexample found for property: '{}'", (Object)this);
            LOGGER.info(Category.COUNTEREXAMPLE, "Spurious counterexample: {}", (Object)result);
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.propertyOracle.getProperty());
    }

    public static class MealyLoggingPropertyOracle<I, O, P>
    extends LoggingPropertyOracle<I, MealyMachine<?, I, ?, O>, P, Word<O>>
    implements PropertyOracle.MealyPropertyOracle<I, O, P> {
        public MealyLoggingPropertyOracle(PropertyOracle.MealyPropertyOracle<I, O, P> property) {
            super(property);
        }
    }

    public static class DFALoggingPropertyOracle<I, P>
    extends LoggingPropertyOracle<I, DFA<?, I>, P, Boolean>
    implements PropertyOracle.DFAPropertyOracle<I, P> {
        public DFALoggingPropertyOracle(PropertyOracle.DFAPropertyOracle<I, P> property) {
            super(property);
        }
    }
}

