/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.property;

import de.learnlib.oracle.EmptinessOracle;
import de.learnlib.oracle.InclusionOracle;
import de.learnlib.oracle.PropertyOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.automaton.concept.Output;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractPropertyOracle<I, A extends Output<I, D>, P, D, R extends A>
implements PropertyOracle<I, A, P, D> {
    private final InclusionOracle<A, I, D> inclusionOracle;
    private final EmptinessOracle<R, I, D> emptinessOracle;
    private P property;
    private @Nullable DefaultQuery<I, D> counterExample;

    protected AbstractPropertyOracle(P property, InclusionOracle<A, I, D> inclusionOracle, EmptinessOracle<R, I, D> emptinessOracle) {
        this.property = property;
        this.inclusionOracle = inclusionOracle;
        this.emptinessOracle = emptinessOracle;
    }

    protected @Nullable DefaultQuery<I, D> setCounterExample(@Nullable DefaultQuery<I, D> counterExample) {
        this.counterExample = counterExample;
        return counterExample;
    }

    public void setProperty(P property) {
        this.property = property;
    }

    public P getProperty() {
        return this.property;
    }

    public @Nullable DefaultQuery<I, D> getCounterExample() {
        return this.counterExample;
    }

    protected abstract R modelCheck(A var1, Collection<? extends I> var2);

    public @Nullable DefaultQuery<I, D> doFindCounterExample(A hypothesis, Collection<? extends I> inputs) {
        R result = this.modelCheck(hypothesis, inputs);
        return result != null ? this.inclusionOracle.findCounterExample(result, inputs) : null;
    }

    public @Nullable DefaultQuery<I, D> disprove(A hypothesis, Collection<? extends I> inputs) {
        R ce = this.modelCheck(hypothesis, inputs);
        return ce != null ? this.setCounterExample(this.emptinessOracle.findCounterExample(ce, inputs)) : null;
    }
}

