/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.property;

import de.learnlib.api.oracle.PropertyOracle;
import de.learnlib.api.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.automatalib.automata.concepts.Output;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PropertyOracleChain<I, A extends Output<I, D>, @Nullable P, D>
implements PropertyOracle<I, A, P, D> {
    private P property;
    private @Nullable DefaultQuery<I, D> counterExample;
    private final List<PropertyOracle<I, ? super A, P, D>> oracles;

    @SafeVarargs
    public PropertyOracleChain(PropertyOracle<I, ? super A, P, D> ... oracles) {
        this(Arrays.asList(oracles));
    }

    public PropertyOracleChain(Collection<? extends PropertyOracle<I, ? super A, P, D>> oracles) {
        this.oracles = new ArrayList<PropertyOracle<I, A, P, D>>(oracles);
        this.property = !this.oracles.isEmpty() ? this.oracles.get(0).getProperty() : null;
    }

    public void addOracle(PropertyOracle<I, ? super A, P, D> oracle) {
        assert (oracle.getProperty() == null || oracle.getProperty().equals(this.property));
        oracle.setProperty(this.property);
        this.oracles.add(oracle);
    }

    public @Nullable DefaultQuery<I, D> doFindCounterExample(A hypothesis, Collection<? extends I> inputs) {
        for (PropertyOracle<I, ? super A, P, D> propertyOracle : this.oracles) {
            DefaultQuery ceQry = propertyOracle.findCounterExample(hypothesis, inputs);
            if (ceQry == null) continue;
            return ceQry;
        }
        return null;
    }

    public @Nullable DefaultQuery<I, D> disprove(A hypothesis, Collection<? extends I> inputs) {
        for (PropertyOracle<I, ? super A, P, D> propertyOracle : this.oracles) {
            DefaultQuery ceQry = propertyOracle.disprove(hypothesis, inputs);
            if (ceQry == null) continue;
            this.counterExample = ceQry;
            return ceQry;
        }
        return null;
    }

    public void setProperty(P property) {
        this.oracles.forEach(o -> o.setProperty(property));
        this.property = property;
    }

    public P getProperty() {
        return this.property;
    }

    public @Nullable DefaultQuery<I, D> getCounterExample() {
        return this.counterExample;
    }
}

