/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.observationpack.vpa;

import com.google.common.collect.Iterables;
import de.learnlib.acex.AbstractBaseCounterexample;
import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.algorithm.observationpack.vpa.AbstractVPALearner;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.AbstractHypTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.ContextPair;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.DTNode;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypLoc;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.StackContents;
import net.automatalib.automaton.vpa.State;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OPLearnerVPA<I>
extends AbstractVPALearner<I> {
    protected final AcexAnalyzer analyzer;

    public OPLearnerVPA(VPAlphabet<I> alphabet, MembershipOracle.DFAMembershipOracle<I> oracle, AcexAnalyzer analyzer) {
        super(alphabet, oracle);
        this.analyzer = analyzer;
    }

    protected State<HypLoc<I>> getDefinitiveSuccessor(State<HypLoc<I>> baseState, Word<I> suffix) {
        return (State)this.hypothesis.getSuccessor(baseState, (Iterable)suffix);
    }

    protected Word<I> transformAccessSequence(State<HypLoc<I>> state) {
        return this.transformAccessSequence(state.getStackContents(), (HypLoc)state.getLocation());
    }

    protected Word<I> transformAccessSequence(@Nullable StackContents contents) {
        return this.transformAccessSequence(contents, (HypLoc<I>)this.hypothesis.getInitialLocation());
    }

    protected Word<I> transformAccessSequence(@Nullable StackContents contents, HypLoc<I> loc) {
        ArrayList<Integer> stackElems = new ArrayList<Integer>();
        if (contents != null) {
            for (StackContents iter = contents; iter != null; iter = iter.pop()) {
                stackElems.add(iter.peek());
            }
        }
        WordBuilder wb = new WordBuilder();
        for (int i = stackElems.size() - 1; i >= 0; --i) {
            int elem = (Integer)stackElems.get(i);
            HypLoc stackLoc = (HypLoc)this.hypothesis.getStackLoc(elem);
            wb.append(stackLoc.getAccessSequence());
            Object callSym = this.hypothesis.getCallSym(elem);
            wb.append(callSym);
        }
        wb.append(loc.getAccessSequence());
        return wb.toWord();
    }

    @Override
    protected boolean refineHypothesisSingle(DefaultQuery<I, Boolean> ceQuery) {
        Word ceWord = ceQuery.getInput();
        boolean hypOut = this.hypothesis.computeOutput((Iterable)ceWord);
        if (hypOut == (Boolean)ceQuery.getOutput()) {
            return false;
        }
        PrefixTransformAcex acex = new PrefixTransformAcex(Word.epsilon(), new ContextPair(Word.epsilon(), ceWord));
        acex.setEffect(0, !hypOut);
        acex.setEffect(acex.getLength() - 1, hypOut);
        int breakpoint = this.analyzer.analyzeAbstractCounterexample((AbstractCounterexample)acex);
        Word prefix = ceWord.prefix(breakpoint);
        Object act = ceWord.getSymbol(breakpoint);
        Word suffix = ceWord.subWord(breakpoint + 1);
        State state = (State)this.hypothesis.getState((Iterable)prefix);
        assert (state != null);
        State succState = (State)this.hypothesis.getSuccessor(state, act);
        assert (succState != null);
        ContextPair<I> context = new ContextPair<I>(this.transformAccessSequence(succState.getStackContents()), suffix);
        AbstractHypTrans<Object> trans = this.hypothesis.getInternalTransition(state, act);
        assert (trans != null);
        HypLoc<Object> newLoc = this.makeTree(trans);
        DTNode oldDtNode = ((HypLoc)succState.getLocation()).getLeaf();
        this.openTransitions.addAll(oldDtNode.getIncoming());
        AbstractDTNode.SplitResult children = oldDtNode.split(context, (Boolean)acex.effect(breakpoint), (Boolean)acex.effect(breakpoint + 1));
        OPLearnerVPA.link((DTNode)children.nodeOld, newLoc);
        OPLearnerVPA.link((DTNode)children.nodeNew, (HypLoc)succState.getLocation());
        this.initializeLocation(trans.getTreeTarget());
        this.closeTransitions();
        return true;
    }

    protected class PrefixTransformAcex
    extends AbstractBaseCounterexample<Boolean> {
        private final Word<I> suffix;
        private final State<HypLoc<I>> baseState;

        public PrefixTransformAcex(Word<I> word, ContextPair<I> context) {
            super(context.getSuffix().length() + 1);
            this.suffix = context.getSuffix();
            this.baseState = (State)OPLearnerVPA.this.hypothesis.getState(Iterables.concat(context.getPrefix(), word));
        }

        public State<HypLoc<I>> getBaseState() {
            return this.baseState;
        }

        public Word<I> getSuffix() {
            return this.suffix;
        }

        public boolean checkEffects(Boolean eff1, Boolean eff2) {
            return eff1.equals(eff2);
        }

        protected Boolean computeEffect(int index) {
            Word suffPref = this.suffix.prefix(index);
            State state = OPLearnerVPA.this.getDefinitiveSuccessor(this.baseState, suffPref);
            Word suffSuff = this.suffix.subWord(index);
            return (Boolean)OPLearnerVPA.this.oracle.answerQuery(OPLearnerVPA.this.transformAccessSequence(state), suffSuff);
        }
    }
}

