/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.oracle.AdaptiveMembershipOracle;
import de.learnlib.oracle.membership.SULAdaptiveOracle;
import de.learnlib.query.AdaptiveQuery;
import de.learnlib.sul.StateLocalInputSUL;
import java.util.Collections;
import java.util.List;

public class StateLocalInputSULAdaptiveOracle<I, O>
extends SULAdaptiveOracle<I, O>
implements AdaptiveMembershipOracle<I, O> {
    private final StateLocalInputSUL<I, O> sul;
    private final O undefinedOutput;
    private boolean fetchRequired;

    public StateLocalInputSULAdaptiveOracle(StateLocalInputSUL<I, O> sul, O undefinedOutput) {
        super(sul);
        this.sul = sul;
        this.undefinedOutput = undefinedOutput;
        this.fetchRequired = true;
    }

    @Override
    public void processQuery(AdaptiveQuery<I, O> query) {
        AdaptiveQuery.Response response;
        this.sul.pre();
        do {
            Object out;
            Object in;
            List inputs;
            if ((inputs = this.fetchRequired ? this.sul.currentlyEnabledInputs() : Collections.emptyList()).contains(in = query.getInput())) {
                out = this.sul.step(in);
            } else {
                this.fetchRequired = false;
                out = this.undefinedOutput;
            }
            response = query.processOutput(out);
            if (response != AdaptiveQuery.Response.RESET) continue;
            this.fetchRequired = true;
            this.sul.post();
            this.sul.pre();
        } while (response != AdaptiveQuery.Response.FINISHED);
        this.fetchRequired = true;
        this.sul.post();
    }
}

