/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.api.StateLocalInputSUL;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class StateLocalInputSULOracle<I, O>
implements MembershipOracle.MealyMembershipOracle<I, O> {
    private final StateLocalInputSUL<I, O> sul;
    private final O undefinedOutput;

    public StateLocalInputSULOracle(StateLocalInputSUL<I, O> sul, O undefinedOutput) {
        this.sul = sul;
        this.undefinedOutput = undefinedOutput;
    }

    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        for (Query<I, Word<O>> q : queries) {
            Word<O> output = this.answerQuery((Word<I>)q.getPrefix(), (Word<I>)q.getSuffix());
            q.answer(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Word<O> answerQuery(Word<I> prefix, Word<I> suffix) {
        try {
            this.sul.pre();
            Collection<Object> enabledInputs = this.sul.currentlyEnabledInputs();
            for (Object sym : prefix) {
                if (enabledInputs.contains(sym)) {
                    this.sul.step(sym);
                    enabledInputs = this.sul.currentlyEnabledInputs();
                    continue;
                }
                enabledInputs = Collections.emptySet();
            }
            WordBuilder wb = new WordBuilder(suffix.length());
            for (Object sym : suffix) {
                if (enabledInputs.contains(sym)) {
                    Object out = this.sul.step(sym);
                    enabledInputs = this.sul.currentlyEnabledInputs();
                    wb.add(out);
                    continue;
                }
                enabledInputs = Collections.emptySet();
                wb.add(this.undefinedOutput);
            }
            Iterator iterator = wb.toWord();
            return iterator;
        }
        finally {
            this.sul.post();
        }
    }
}

