/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.api.oracle.QueryAnswerer;
import de.learnlib.api.oracle.SingleQueryOracle;
import de.learnlib.api.query.Query;
import de.learnlib.util.MQUtil;
import java.util.Collection;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;

public class SimulatorOracle<I, D>
implements SingleQueryOracle<I, D> {
    private final SuffixOutput<I, D> automaton;

    public SimulatorOracle(SuffixOutput<I, D> automaton) {
        this.automaton = automaton;
    }

    public D answerQuery(Word<I> prefix, Word<I> suffix) {
        return (D)this.automaton.computeSuffixOutput(prefix, suffix);
    }

    public void processQueries(Collection<? extends Query<I, D>> queries) {
        MQUtil.answerQueriesAuto((QueryAnswerer)this, queries);
    }

    public static class MealySimulatorOracle<I, O>
    extends SimulatorOracle<I, Word<O>>
    implements SingleQueryOracle.SingleQueryOracleMealy<I, O> {
        public MealySimulatorOracle(MealyMachine<?, I, ?, O> mealy) {
            super(mealy);
        }
    }

    public static class DFASimulatorOracle<I>
    extends SimulatorOracle<I, Boolean>
    implements SingleQueryOracle.SingleQueryOracleDFA<I> {
        public DFASimulatorOracle(DFA<?, I> dfa) {
            super(dfa);
        }
    }
}

