/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.api.SUL;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SULOracle<I, O>
implements MembershipOracle.MealyMembershipOracle<I, O> {
    private final SUL<I, O> sul;
    private final @Nullable ThreadLocal<SUL<I, O>> localSul;

    public SULOracle(SUL<I, O> sul) {
        this.sul = sul;
        this.localSul = sul.canFork() ? ThreadLocal.withInitial(() -> sul.fork()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        if (this.localSul != null) {
            SULOracle.processQueries(this.localSul.get(), queries);
        } else {
            SUL<I, O> sUL = this.sul;
            synchronized (sUL) {
                SULOracle.processQueries(this.sul, queries);
            }
        }
    }

    private static <I, O> void processQueries(SUL<I, O> sul, Collection<? extends Query<I, Word<O>>> queries) {
        for (Query<I, Word<O>> q : queries) {
            Word<O> output = SULOracle.answerQuery(sul, q.getPrefix(), q.getSuffix());
            q.answer(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> Word<O> answerQuery(SUL<I, O> sul, Word<I> prefix, Word<I> suffix) {
        sul.pre();
        try {
            for (Object sym : prefix) {
                sul.step(sym);
            }
            WordBuilder wb = new WordBuilder(suffix.length());
            for (Object sym : suffix) {
                wb.add(sul.step(sym));
            }
            Iterator iterator = wb.toWord();
            return iterator;
        }
        finally {
            sul.post();
        }
    }
}

