/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.api.ObservableSUL;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.oracle.OmegaMembershipOracle;
import de.learnlib.api.query.OmegaQuery;
import de.learnlib.oracle.membership.SULOracle;
import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.commons.util.Pair;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractSULOmegaOracle<S, I, O, Q>
implements OmegaMembershipOracle.MealyOmegaMembershipOracle<Q, I, O> {
    private final ObservableSUL<S, I, O> sul;
    private final @Nullable ThreadLocal<ObservableSUL<S, I, O>> localSul;

    protected AbstractSULOmegaOracle(ObservableSUL<S, I, O> sul) {
        this.sul = sul;
        this.localSul = sul.canFork() ? ThreadLocal.withInitial(() -> sul.fork()) : null;
    }

    public ObservableSUL<S, I, O> getSul() {
        if (this.localSul != null) {
            return this.localSul.get();
        }
        return this.sul;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends OmegaQuery<I, Word<O>>> queries) {
        if (this.localSul != null) {
            this.processQueries(this.localSul.get(), queries);
        } else {
            ObservableSUL<S, I, O> observableSUL = this.sul;
            synchronized (observableSUL) {
                this.processQueries(this.sul, queries);
            }
        }
    }

    private void processQueries(ObservableSUL<S, I, O> sul, Collection<? extends OmegaQuery<I, Word<O>>> queries) {
        for (OmegaQuery<I, Word<O>> q : queries) {
            Pair<Word<O>, Integer> output = this.answerQuery(sul, q.getPrefix(), q.getLoop(), q.getRepeat());
            q.answer(output.getFirst(), ((Integer)output.getSecond()).intValue());
        }
    }

    protected abstract Q getQueryState(ObservableSUL<S, I, O> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Word<O>, Integer> answerQuery(ObservableSUL<S, I, O> sul, Word<I> prefix, Word<I> loop, int repeat) {
        assert (repeat > 0);
        sul.pre();
        try {
            int i;
            int traceLength = prefix.length() + loop.length() * repeat;
            WordBuilder inputBuilder = new WordBuilder(traceLength, prefix);
            WordBuilder outputBuilder = new WordBuilder(traceLength);
            ArrayList<Q> states = new ArrayList<Q>(repeat + 1);
            for (i = 0; i < prefix.length(); ++i) {
                outputBuilder.append(sul.step(prefix.getSymbol(i)));
            }
            states.add(this.getQueryState(sul));
            for (i = 0; i < repeat; ++i) {
                inputBuilder.append(loop);
                for (int j = 0; j < loop.length(); ++j) {
                    outputBuilder.append(sul.step(loop.getSymbol(j)));
                }
                Q nextState = this.getQueryState(sul);
                int prefixLength = prefix.length();
                for (Object q : states) {
                    if (this.isSameState(inputBuilder.toWord(), nextState, inputBuilder.toWord(0, prefixLength), q)) {
                        Pair pair = Pair.of((Object)outputBuilder.toWord(), (Object)(i + 1));
                        return pair;
                    }
                    prefixLength += loop.length();
                }
                states.add(nextState);
            }
            Pair pair = Pair.of(null, (Object)-1);
            return pair;
        }
        finally {
            sul.post();
        }
    }

    public MembershipOracle.MealyMembershipOracle<I, O> getMembershipOracle() {
        return new SULOracle(this.sul);
    }

    public static <S, I, O> AbstractSULOmegaOracle<S, I, O, ?> newOracle(ObservableSUL<S, I, O> sul, boolean deepCopies) {
        AbstractSULOmegaOracle abstractSulOmegaOracle;
        if (deepCopies) {
            if (!sul.deepCopies()) {
                throw new IllegalArgumentException("SUL can not make deep copies of states.");
            }
            abstractSulOmegaOracle = new DeepCopySULOmegaOracle<S, I, O>(sul);
        } else {
            if (!sul.canFork()) {
                throw new IllegalArgumentException("SUL must be forkable.");
            }
            abstractSulOmegaOracle = new ShallowCopySULOmegaOracle<S, I, O>(sul);
        }
        return abstractSulOmegaOracle;
    }

    public static <S, I, O> AbstractSULOmegaOracle<S, I, O, ?> newOracle(ObservableSUL<S, I, O> sul) {
        return AbstractSULOmegaOracle.newOracle(sul, !sul.canFork());
    }

    private static final class DeepCopySULOmegaOracle<S, I, O>
    extends AbstractSULOmegaOracle<S, I, O, S> {
        DeepCopySULOmegaOracle(ObservableSUL<S, I, O> sul) {
            super(sul);
        }

        @Override
        protected S getQueryState(ObservableSUL<S, I, O> sul) {
            return (S)sul.getState();
        }

        public boolean isSameState(Word<I> input1, S s1, Word<I> input2, S s2) {
            return s1.equals(s2);
        }
    }

    private static final class ShallowCopySULOmegaOracle<S, I, O>
    extends AbstractSULOmegaOracle<S, I, O, Integer> {
        private final ObservableSUL<S, I, O> forkedSUL;

        ShallowCopySULOmegaOracle(ObservableSUL<S, I, O> sul) {
            super(sul);
            assert (sul.canFork());
            this.forkedSUL = sul.fork();
        }

        @Override
        protected Integer getQueryState(ObservableSUL<S, I, O> sul) {
            return sul.getState().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSameState(Word<I> input1, Integer s1, Word<I> input2, Integer s2) {
            if (!s1.equals(s2)) {
                return false;
            }
            ObservableSUL sul1 = this.getSul();
            ObservableSUL<S, I, O> sul2 = this.forkedSUL;
            assert (s1.equals(sul1.getState().hashCode()));
            sul2.pre();
            try {
                for (Object sym : input2) {
                    sul2.step(sym);
                }
                assert (sul1.getState().hashCode() == sul2.getState().hashCode());
                assert (s2.equals(sul2.getState().hashCode()));
                boolean bl = sul1.getState().equals(sul2.getState());
                return bl;
            }
            finally {
                sul2.post();
            }
        }
    }
}

