/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mapper.api;

import de.learnlib.api.Mapper;
import de.learnlib.api.exception.SULException;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface SULMapper<AI, AO, CI, CO>
extends Mapper.SynchronousMapper<AI, AO, CI, CO> {
    default public boolean canFork() {
        return false;
    }

    default public SULMapper<AI, AO, CI, CO> fork() {
        throw new UnsupportedOperationException();
    }

    default public MappedException<? extends AO> mapWrappedException(SULException exception) {
        return this.mapUnwrappedException((RuntimeException)exception);
    }

    default public MappedException<? extends AO> mapUnwrappedException(RuntimeException exception) {
        throw exception;
    }

    public static final class MappedException<AO> {
        private final AO thisStepOutput;
        private final Optional<AO> subsequentStepsOutput;

        private MappedException(AO output) {
            this(output, null);
        }

        private MappedException(AO thisStepOutput, @Nullable AO subsequentStepsOutput) {
            this.thisStepOutput = thisStepOutput;
            this.subsequentStepsOutput = Optional.ofNullable(subsequentStepsOutput);
        }

        public static <AO> MappedException<AO> ignoreAndContinue(AO output) {
            return new MappedException<AO>(output);
        }

        public static <AO> MappedException<AO> repeatOutput(AO output) {
            return MappedException.repeatOutput(output, output);
        }

        public static <AO> MappedException<AO> repeatOutput(AO thisStepOutput, AO subsequentOutput) {
            return new MappedException<AO>(thisStepOutput, subsequentOutput);
        }

        public static <AO> MappedException<AO> pass(SULException exception) {
            throw exception;
        }

        public AO getThisStepOutput() {
            return this.thisStepOutput;
        }

        public Optional<AO> getSubsequentStepsOutput() {
            return this.subsequentStepsOutput;
        }
    }
}

