/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mapper;

import de.learnlib.api.SUL;
import de.learnlib.api.exception.SULException;
import de.learnlib.mapper.api.SULMapper;
import java.util.Optional;

public class MappedSUL<AI, AO, CI, CO>
implements SUL<AI, AO> {
    private final SULMapper<? super AI, ? extends AO, ? extends CI, ? super CO> mapper;
    private final SUL<? super CI, ? extends CO> sul;
    private boolean inError;
    private AO repeatedErrorOutput;

    public MappedSUL(SULMapper<? super AI, ? extends AO, ? extends CI, ? super CO> mapper, SUL<? super CI, ? extends CO> sul) {
        this.mapper = mapper;
        this.sul = sul;
    }

    public void pre() {
        this.inError = false;
        this.repeatedErrorOutput = null;
        this.mapper.pre();
        this.sul.pre();
    }

    public void post() {
        this.sul.post();
        this.mapper.post();
    }

    public AO step(AI in) throws SULException {
        SULMapper.MappedException<AO> mappedEx;
        if (this.inError) {
            return this.repeatedErrorOutput;
        }
        Object concreteInput = this.mapper.mapInput(in);
        try {
            Object concreteOutput = this.sul.step(concreteInput);
            return (AO)this.mapper.mapOutput(concreteOutput);
        }
        catch (SULException ex) {
            mappedEx = this.mapper.mapWrappedException(ex);
        }
        catch (RuntimeException ex) {
            mappedEx = this.mapper.mapUnwrappedException(ex);
        }
        Optional<AO> repeatOutput = mappedEx.getSubsequentStepsOutput();
        if (repeatOutput.isPresent()) {
            this.inError = true;
            this.repeatedErrorOutput = repeatOutput.get();
        }
        return mappedEx.getThisStepOutput();
    }

    public boolean canFork() {
        return this.mapper.canFork() && this.sul.canFork();
    }

    public MappedSUL<AI, AO, CI, CO> fork() {
        return new MappedSUL<AI, AO, CI, CO>(this.mapper.fork(), this.sul.fork());
    }
}

