/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mapper.api;

import com.google.common.base.Optional;
import de.learnlib.api.SULException;

public interface Mapper<AI, AO, CI, CO> {
    public void pre();

    public void post();

    public CI mapInput(AI var1);

    public AO mapOutput(CO var1);

    public MappedException<? extends AO> mapWrappedException(SULException var1) throws SULException;

    public MappedException<? extends AO> mapUnwrappedException(RuntimeException var1) throws SULException, RuntimeException;

    public static final class MappedException<AO> {
        private final AO thisStepOutput;
        private final Optional<AO> subsequentStepsOutput;

        public static <AO> MappedException<AO> ignoreAndContinue(AO output) {
            return new MappedException<AO>(output);
        }

        public static <AO> MappedException<AO> repeatOutput(AO thisStepOutput, AO subsequentOutput) {
            return new MappedException<AO>(thisStepOutput, subsequentOutput);
        }

        public static <AO> MappedException<AO> repeatOutput(AO output) {
            return MappedException.repeatOutput(output, output);
        }

        public static <AO> MappedException<AO> pass(SULException exception) throws SULException {
            throw exception;
        }

        private MappedException(AO thisStepOutput, AO subsequentStepsOutput) {
            this.thisStepOutput = thisStepOutput;
            this.subsequentStepsOutput = Optional.of(subsequentStepsOutput);
        }

        private MappedException(AO output) {
            this.thisStepOutput = output;
            this.subsequentStepsOutput = Optional.absent();
        }

        public AO getThisStepOutput() {
            return this.thisStepOutput;
        }

        public Optional<AO> getSubsequentStepsOutput() {
            return this.subsequentStepsOutput;
        }
    }
}

