/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mapper;

import com.google.common.base.Optional;
import de.learnlib.api.SULException;
import de.learnlib.mapper.api.Mapper;

final class MapperComposition<AI, AO, ACI, CAO, CI, CO>
implements Mapper<AI, AO, CI, CO> {
    private final Mapper<? super AI, ? extends AO, ACI, CAO> mapper1;
    private final Mapper<? super ACI, ? extends CAO, ? extends CI, ? super CO> mapper2;

    public MapperComposition(Mapper<? super AI, ? extends AO, ACI, CAO> outerMapper, Mapper<? super ACI, ? extends CAO, ? extends CI, ? super CO> innerMapper) {
        this.mapper1 = outerMapper;
        this.mapper2 = innerMapper;
    }

    @Override
    public void pre() {
        this.mapper1.pre();
        this.mapper2.pre();
    }

    @Override
    public void post() {
        this.mapper2.post();
        this.mapper1.post();
    }

    @Override
    public CI mapInput(AI abstractInput) {
        ACI aci = this.mapper1.mapInput(abstractInput);
        return this.mapper2.mapInput(aci);
    }

    @Override
    public AO mapOutput(CO concreteOutput) {
        CAO cao = this.mapper2.mapOutput(concreteOutput);
        return this.mapper1.mapOutput(cao);
    }

    @Override
    public Mapper.MappedException<? extends AO> mapWrappedException(SULException exception) {
        Mapper.MappedException<? extends CAO> mappedEx;
        try {
            mappedEx = this.mapper2.mapWrappedException(exception);
        }
        catch (SULException ex) {
            return this.mapper1.mapWrappedException(ex);
        }
        catch (RuntimeException ex) {
            return this.mapper1.mapUnwrappedException(ex);
        }
        return this.mapMappedException(mappedEx);
    }

    @Override
    public Mapper.MappedException<? extends AO> mapUnwrappedException(RuntimeException exception) throws RuntimeException {
        Mapper.MappedException<? extends CAO> mappedEx;
        try {
            mappedEx = this.mapper2.mapUnwrappedException(exception);
        }
        catch (SULException ex) {
            return this.mapper1.mapWrappedException(ex);
        }
        catch (RuntimeException ex) {
            return this.mapper1.mapUnwrappedException(ex);
        }
        return this.mapMappedException(mappedEx);
    }

    private Mapper.MappedException<? extends AO> mapMappedException(Mapper.MappedException<? extends CAO> mappedEx) {
        AO thisStepOutput = this.mapper1.mapOutput(mappedEx.getThisStepOutput());
        Optional<? extends CAO> repeatOutput = mappedEx.getSubsequentStepsOutput();
        if (repeatOutput.isPresent()) {
            AO repeatOutputMapped = this.mapper1.mapOutput(repeatOutput.get());
            return Mapper.MappedException.repeatOutput(thisStepOutput, repeatOutputMapped);
        }
        return Mapper.MappedException.ignoreAndContinue(thisStepOutput);
    }
}

