/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mapper;

import com.google.common.base.Optional;
import de.learnlib.api.SUL;
import de.learnlib.api.SULException;
import de.learnlib.mapper.api.Mapper;

public class MappedSUL<AI, AO, CI, CO>
implements SUL<AI, AO> {
    private final Mapper<? super AI, ? extends AO, ? extends CI, ? super CO> mapper;
    private final SUL<? super CI, ? extends CO> sul;
    private boolean inError = false;
    private AO repeatedErrorOutput = null;

    public MappedSUL(Mapper<? super AI, ? extends AO, ? extends CI, ? super CO> mapper, SUL<? super CI, ? extends CO> sul) {
        this.mapper = mapper;
        this.sul = sul;
    }

    public void pre() {
        this.mapper.pre();
        this.sul.pre();
    }

    public void post() {
        this.sul.post();
        this.mapper.post();
        this.inError = false;
        this.repeatedErrorOutput = null;
    }

    public AO step(AI in) throws SULException {
        Mapper.MappedException<AO> mappedEx;
        if (this.inError) {
            return this.repeatedErrorOutput;
        }
        CI concreteInput = this.mapper.mapInput(in);
        try {
            Object concreteOutput = this.sul.step(concreteInput);
            return this.mapper.mapOutput(concreteOutput);
        }
        catch (SULException ex) {
            mappedEx = this.mapper.mapWrappedException(ex);
        }
        catch (RuntimeException ex) {
            mappedEx = this.mapper.mapUnwrappedException(ex);
        }
        Optional<? extends AO> repeatOutput = mappedEx.getSubsequentStepsOutput();
        if (repeatOutput.isPresent()) {
            this.inError = true;
            this.repeatedErrorOutput = repeatOutput.get();
        }
        return mappedEx.getThisStepOutput();
    }
}

