/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstar.mealy;

import de.learnlib.algorithms.lstar.AbstractExtensibleAutomatonLStar;
import de.learnlib.algorithms.lstar.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstar.closing.ClosingStrategy;
import de.learnlib.algorithms.lstar.mealy.LStarMealyUtil;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.util.mealy.MealyUtil;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.automata.transducers.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassicLStarMealy<I, O>
extends AbstractExtensibleAutomatonLStar<MealyMachine<?, I, ?, O>, I, O, Integer, CompactMealyTransition<O>, Void, O, CompactMealy<I, O>> {
    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, @Nullable O> oracle, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        this(alphabet, oracle, Collections.singletonList(Word.epsilon()), Collections.emptyList(), cexHandler, closingStrategy);
    }

    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, @Nullable O> oracle, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        super(alphabet, oracle, new CompactMealy(alphabet), initialPrefixes, LStarMealyUtil.ensureSuffixCompliancy(initialSuffixes, alphabet, true), cexHandler, closingStrategy);
    }

    public static <I, O> ClassicLStarMealy<I, O> createForSymbolOracle(Alphabet<I> alphabet, MembershipOracle<I, @Nullable O> oracle, ObservationTableCEXHandler<I, O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        return new ClassicLStarMealy<I, O>(alphabet, oracle, cexHandler, closingStrategy);
    }

    public static <I, O> ClassicLStarMealy<I, O> createForWordOracle(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        return new ClassicLStarMealy<I, O>(alphabet, MealyUtil.wrapWordOracle(oracle), cexHandler, closingStrategy);
    }

    @Override
    protected MealyMachine<?, I, ?, O> exposeInternalHypothesis() {
        return (MealyMachine)this.internalHyp;
    }

    @Override
    protected Void stateProperty(ObservationTable<I, @Nullable O> table, Row<I> stateRow) {
        return null;
    }

    @Override
    protected O transitionProperty(ObservationTable<I, @Nullable O> table, Row<I> stateRow, int inputIdx) {
        return (O)table.cellContents(stateRow, inputIdx);
    }

    @Override
    protected SuffixOutput<I, @Nullable O> hypothesisOutput() {
        return new SuffixOutput<I, O>(){

            public @Nullable O computeOutput(Iterable<? extends I> input) {
                return this.computeSuffixOutput(Collections.emptyList(), input);
            }

            public @Nullable O computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
                Word wordOut = (Word)((CompactMealy)ClassicLStarMealy.this.internalHyp).computeSuffixOutput(prefix, suffix);
                if (wordOut.isEmpty()) {
                    return null;
                }
                return wordOut.lastSymbol();
            }
        };
    }
}

