/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstar.mealy;

import de.learnlib.algorithms.lstar.AbstractExtensibleAutomatonLStar;
import de.learnlib.algorithms.lstar.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstar.closing.ClosingStrategy;
import de.learnlib.algorithms.lstar.mealy.LStarMealyUtil;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.util.mealy.MealyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.MutableMealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.automata.transout.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class ClassicLStarMealy<I, O>
extends AbstractExtensibleAutomatonLStar<MealyMachine<?, I, ?, O>, I, O, Integer, CompactMealyTransition<O>, Void, O, CompactMealy<I, O>> {
    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        this(alphabet, oracle, Collections.singletonList(Word.epsilon()), Collections.emptyList(), cexHandler, closingStrategy);
    }

    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        super(alphabet, oracle, new CompactMealy(alphabet), initialPrefixes, LStarMealyUtil.ensureSuffixCompliancy(initialSuffixes, alphabet, true), cexHandler, closingStrategy);
    }

    public static <A extends MutableMealyMachine<?, I, ?, O>, I, O> ClassicLStarMealy<I, O> createForSymbolOracle(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, ObservationTableCEXHandler<I, O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        return new ClassicLStarMealy<I, O>(alphabet, oracle, cexHandler, closingStrategy);
    }

    public static <A extends MutableMealyMachine<?, I, ?, O>, I, O> ClassicLStarMealy<I, O> createForWordOracle(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        return new ClassicLStarMealy<I, O>(alphabet, MealyUtil.wrapWordOracle(oracle), cexHandler, closingStrategy);
    }

    @Override
    protected List<Word<I>> initialSuffixes() {
        ArrayList<Word<I>> suffixes = new ArrayList<Word<I>>(this.alphabet.size());
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object sym = this.alphabet.getSymbol(i);
            suffixes.add(Word.fromLetter((Object)sym));
        }
        return suffixes;
    }

    @Override
    protected MealyMachine<?, I, ?, O> exposeInternalHypothesis() {
        return (MealyMachine)this.internalHyp;
    }

    @Override
    protected Void stateProperty(ObservationTable<I, O> table, Row<I> stateRow) {
        return null;
    }

    @Override
    protected O transitionProperty(ObservationTable<I, O> table, Row<I> stateRow, int inputIdx) {
        return (O)table.cellContents(stateRow, inputIdx);
    }

    @Override
    protected SuffixOutput<I, O> hypothesisOutput() {
        return new SuffixOutput<I, O>(){

            public O computeOutput(Iterable<? extends I> input) {
                return this.computeSuffixOutput(Collections.emptyList(), input);
            }

            public O computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
                Word wordOut = (Word)((CompactMealy)ClassicLStarMealy.this.internalHyp).computeSuffixOutput(prefix, suffix);
                if (wordOut.isEmpty()) {
                    return null;
                }
                return wordOut.lastSymbol();
            }
        };
    }
}

