/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstar.closing;

import de.learnlib.algorithms.lstar.closing.CloseRandomStrategy;
import de.learnlib.algorithms.lstar.closing.ClosingStrategy;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.automatalib.commons.util.comparison.CmpUtil;
import net.automatalib.words.Alphabet;

public final class ClosingStrategies {
    public static final ClosingStrategy<Object, Object> CLOSE_RANDOM = new CloseRandomStrategy();
    public static final ClosingStrategy<Object, Object> CLOSE_FIRST = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RD> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RD> table, MembershipOracle<RI, RD> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>(unclosedClasses.size());
            for (List<Row<RI>> clazz : unclosedClasses) {
                result.add(clazz.get(0));
            }
            return result;
        }

        public String toString() {
            return "CloseFirst";
        }
    };
    public static final ClosingStrategy<Object, Object> CLOSE_SHORTEST = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RD> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RD> table, MembershipOracle<RI, RD> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>();
            for (List<Row<RI>> clazz : unclosedClasses) {
                Row<RI> shortest = null;
                int shortestLen = Integer.MAX_VALUE;
                for (Row<RI> row : clazz) {
                    int prefixLen = row.getLabel().length();
                    if (shortest != null && prefixLen >= shortestLen) continue;
                    shortest = row;
                    shortestLen = prefixLen;
                }
                result.add(shortest);
            }
            return result;
        }

        public String toString() {
            return "CloseShortest";
        }
    };
    public static final ClosingStrategy<Object, Object> CLOSE_LEX_MIN = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RD> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RD> table, MembershipOracle<RI, RD> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>(unclosedClasses.size());
            Alphabet alphabet = table.getInputAlphabet();
            for (List<Row<RI>> clazz : unclosedClasses) {
                Row<RI> lexMin = null;
                for (Row<RI> row : clazz) {
                    if (lexMin == null) {
                        lexMin = row;
                        continue;
                    }
                    if (CmpUtil.lexCompare((Iterable)row.getLabel(), (Iterable)lexMin.getLabel(), (Comparator)alphabet) >= 0) continue;
                    lexMin = row;
                }
                result.add(lexMin);
            }
            return result;
        }

        public String toString() {
            return "CloseLexMin";
        }
    };

    private ClosingStrategies() {
    }

    public static ClosingStrategy<Object, Object>[] values() {
        return new ClosingStrategy[]{CLOSE_RANDOM, CLOSE_FIRST, CLOSE_SHORTEST, CLOSE_LEX_MIN};
    }
}

