/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstar;

import de.learnlib.algorithms.lstar.ce.ObservationTableCEXHandlers;
import de.learnlib.api.algorithm.feature.GlobalSuffixLearner;
import de.learnlib.api.algorithm.feature.SupportsGrowingAlphabet;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.observationtable.GenericObservationTable;
import de.learnlib.datastructure.observationtable.Inconsistency;
import de.learnlib.datastructure.observationtable.OTLearner;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.util.MQUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public abstract class AbstractLStar<A, I, D>
implements OTLearner<A, I, D>,
GlobalSuffixLearner<A, I, D>,
SupportsGrowingAlphabet<I> {
    protected Alphabet<I> alphabet;
    protected final MembershipOracle<I, D> oracle;
    protected GenericObservationTable<I, D> table;

    protected AbstractLStar(Alphabet<I> alphabet, MembershipOracle<I, D> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.table = new GenericObservationTable(alphabet);
    }

    public void startLearning() {
        List<Word<I>> prefixes = this.initialPrefixes();
        List<Word<I>> suffixes = this.initialSuffixes();
        List initialUnclosed = this.table.initialize(prefixes, suffixes, this.oracle);
        this.completeConsistentTable(initialUnclosed, this.table.isInitialConsistencyCheckRequired());
    }

    public final boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        if (!MQUtil.isCounterexample(ceQuery, this.hypothesisOutput())) {
            return false;
        }
        int oldDistinctRows = this.table.numberOfDistinctRows();
        this.doRefineHypothesis(ceQuery);
        assert (this.table.numberOfDistinctRows() > oldDistinctRows);
        return true;
    }

    protected abstract SuffixOutput<I, D> hypothesisOutput();

    protected void doRefineHypothesis(DefaultQuery<I, D> ceQuery) {
        List<List<Row<I>>> unclosed = this.incorporateCounterExample(ceQuery);
        this.completeConsistentTable(unclosed, true);
    }

    protected List<List<Row<I>>> incorporateCounterExample(DefaultQuery<I, D> ce) {
        return ObservationTableCEXHandlers.handleClassicLStar(ce, this.table, this.oracle);
    }

    protected List<Word<I>> initialPrefixes() {
        return Collections.singletonList(Word.epsilon());
    }

    protected abstract List<Word<I>> initialSuffixes();

    protected boolean completeConsistentTable(List<List<Row<I>>> unclosed, boolean checkConsistency) {
        boolean refined = false;
        List unclosedIter = unclosed;
        while (true) {
            if (!unclosedIter.isEmpty()) {
                List<Row<I>> closingRows = this.selectClosingRows(unclosedIter);
                unclosedIter = this.table.toShortPrefixes(closingRows, this.oracle);
                refined = true;
                continue;
            }
            if (checkConsistency) {
                Inconsistency incons;
                do {
                    if ((incons = this.table.findInconsistency()) == null) continue;
                    Word<I> newSuffix = this.analyzeInconsistency(incons);
                    unclosedIter = this.table.addSuffix(newSuffix, this.oracle);
                } while (unclosedIter.isEmpty() && incons != null);
            }
            if (unclosedIter.isEmpty()) break;
        }
        return refined;
    }

    protected List<Row<I>> selectClosingRows(List<List<Row<I>>> unclosed) {
        ArrayList<Row<I>> closingRows = new ArrayList<Row<I>>(unclosed.size());
        for (List<Row<I>> rowList : unclosed) {
            closingRows.add(rowList.get(0));
        }
        return closingRows;
    }

    protected Word<I> analyzeInconsistency(Inconsistency<I> incons) {
        int inputIdx = this.alphabet.getSymbolIndex(incons.getSymbol());
        Row succRow1 = incons.getFirstRow().getSuccessor(inputIdx);
        Row succRow2 = incons.getSecondRow().getSuccessor(inputIdx);
        int numSuffixes = this.table.getSuffixes().size();
        for (int i = 0; i < numSuffixes; ++i) {
            Object val2;
            Object val1 = this.table.cellContents(succRow1, i);
            if (Objects.equals(val1, val2 = this.table.cellContents(succRow2, i))) continue;
            Object sym = this.alphabet.getSymbol(inputIdx);
            Word suffix = (Word)this.table.getSuffixes().get(i);
            return suffix.prepend(sym);
        }
        throw new IllegalArgumentException("Bogus inconsistency");
    }

    public Collection<Word<I>> getGlobalSuffixes() {
        return Collections.unmodifiableCollection(this.table.getSuffixes());
    }

    public boolean addGlobalSuffixes(Collection<? extends Word<I>> newGlobalSuffixes) {
        List unclosed = this.table.addSuffixes(newGlobalSuffixes, this.oracle);
        if (unclosed.isEmpty()) {
            return false;
        }
        return this.completeConsistentTable(unclosed, false);
    }

    public ObservationTable<I, D> getObservationTable() {
        return this.table;
    }

    public void addAlphabetSymbol(I symbol) {
        if (this.alphabet.containsSymbol(symbol)) {
            return;
        }
        List unclosed = this.table.addAlphabetSymbol(symbol, this.oracle);
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet = Alphabets.withNewSymbol(this.alphabet, symbol);
        }
        this.completeConsistentTable(unclosed, true);
    }
}

