/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstar;

import de.learnlib.algorithms.lstar.AbstractAutomatonLStar;
import de.learnlib.algorithms.lstar.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstar.ce.ObservationTableCEXHandlers;
import de.learnlib.algorithms.lstar.closing.ClosingStrategies;
import de.learnlib.algorithms.lstar.closing.ClosingStrategy;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.observationtable.Row;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.GrowableAlphabetAutomaton;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class AbstractExtensibleAutomatonLStar<A, I, D, S, T, SP, TP, AI extends MutableDeterministic<S, I, T, SP, TP> & GrowableAlphabetAutomaton<I>>
extends AbstractAutomatonLStar<A, I, D, S, T, SP, TP, AI> {
    protected final ObservationTableCEXHandler<? super I, ? super D> cexHandler;
    protected final ClosingStrategy<? super I, ? super D> closingStrategy;
    protected final List<Word<I>> initialPrefixes;
    protected final List<Word<I>> initialSuffixes;

    protected AbstractExtensibleAutomatonLStar(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, AI internalHyp, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super D> cexHandler, ClosingStrategy<? super I, ? super D> closingStrategy) {
        super(alphabet, oracle, internalHyp);
        this.initialPrefixes = initialPrefixes;
        this.initialSuffixes = initialSuffixes;
        this.cexHandler = cexHandler;
        this.closingStrategy = closingStrategy;
    }

    @Override
    protected void refineHypothesisInternal(DefaultQuery<I, D> ceQuery) {
        List<List<Row<I>>> unclosed = this.cexHandler.handleCounterexample(ceQuery, this.table, this.hypothesisOutput(), this.oracle);
        this.completeConsistentTable(unclosed, this.cexHandler.needsConsistencyCheck());
    }

    @Override
    protected List<Word<I>> initialPrefixes() {
        return this.initialPrefixes;
    }

    @Override
    protected List<Word<I>> initialSuffixes() {
        return this.initialSuffixes;
    }

    @Override
    protected List<Row<I>> selectClosingRows(List<List<Row<I>>> unclosed) {
        return this.closingStrategy.selectClosingRows(unclosed, this.table, this.oracle);
    }

    public static final class BuilderDefaults {
        public static <I> List<Word<I>> initialPrefixes() {
            return Collections.singletonList(Word.epsilon());
        }

        public static <I> List<Word<I>> initialSuffixes() {
            return Collections.emptyList();
        }

        public static <I, D> ObservationTableCEXHandler<? super I, ? super D> cexHandler() {
            return ObservationTableCEXHandlers.CLASSIC_LSTAR;
        }

        public static <I, D> ClosingStrategy<? super I, ? super D> closingStrategy() {
            return ClosingStrategies.CLOSE_FIRST;
        }
    }
}

