/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstar;

import de.learnlib.algorithms.lstar.AbstractLStar;
import de.learnlib.algorithms.lstar.AutomatonLStarState;
import de.learnlib.api.algorithm.feature.ResumableLearner;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.GrowableAlphabetAutomaton;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.SymbolHidingAlphabet;

public abstract class AbstractAutomatonLStar<A, I, D, S, T, SP, TP, AI extends MutableDeterministic<S, I, T, SP, TP> & GrowableAlphabetAutomaton<I>>
extends AbstractLStar<A, I, D>
implements ResumableLearner<AutomatonLStarState<I, D, AI, S>> {
    protected AI internalHyp;
    protected List<StateInfo<S, I>> stateInfos = new ArrayList<StateInfo<S, I>>();

    protected AbstractAutomatonLStar(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, AI internalHyp) {
        super(SymbolHidingAlphabet.wrapIfMutable(alphabet), oracle);
        this.internalHyp = internalHyp;
        internalHyp.clear();
    }

    public A getHypothesisModel() {
        return this.exposeInternalHypothesis();
    }

    protected abstract A exposeInternalHypothesis();

    @Override
    public final void startLearning() {
        super.startLearning();
        this.updateInternalHypothesis();
    }

    protected void updateInternalHypothesis() {
        if (!this.table.isInitialized()) {
            throw new IllegalStateException("Cannot update internal hypothesis: not initialized");
        }
        int oldStates = this.internalHyp.size();
        int numDistinct = this.table.numberOfDistinctRows();
        int newStates = numDistinct - oldStates;
        this.stateInfos.addAll(CollectionsUtil.nullList((int)newStates));
        for (Row row : this.table.getShortPrefixRows()) {
            int id = row.getRowContentId();
            StateInfo<S, I> info = this.stateInfos.get(id);
            if (info != null) {
                if (info.getRow() != row) continue;
                this.internalHyp.setStateProperty(info.getState(), this.stateProperty((ObservationTable<I, D>)this.table, (Row<I>)row));
                continue;
            }
            S state = this.createState(id == 0, row);
            this.stateInfos.set(id, new StateInfo(row, state));
        }
        for (StateInfo stateInfo : this.stateInfos) {
            Row sp = stateInfo.getRow();
            Object state = stateInfo.getState();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                Object input = this.alphabet.getSymbol(i);
                Row succ = sp.getSuccessor(i);
                int succId = succ.getRowContentId();
                S succState = this.stateInfos.get(succId).getState();
                this.setTransition(state, input, succState, sp, i);
            }
        }
    }

    protected abstract SP stateProperty(ObservationTable<I, D> var1, Row<I> var2);

    protected S createState(boolean initial, Row<I> row) {
        SP prop = this.stateProperty((ObservationTable<I, D>)this.table, row);
        if (initial) {
            return (S)this.internalHyp.addInitialState(prop);
        }
        return (S)this.internalHyp.addState(prop);
    }

    protected void setTransition(S from, I input, S to, Row<I> fromRow, int inputIdx) {
        TP prop = this.transitionProperty((ObservationTable<I, D>)this.table, fromRow, inputIdx);
        this.internalHyp.setTransition(from, input, to, prop);
    }

    protected abstract TP transitionProperty(ObservationTable<I, D> var1, Row<I> var2, int var3);

    @Override
    protected final void doRefineHypothesis(DefaultQuery<I, D> ceQuery) {
        this.refineHypothesisInternal(ceQuery);
        this.updateInternalHypothesis();
    }

    protected void refineHypothesisInternal(DefaultQuery<I, D> ceQuery) {
        super.doRefineHypothesis(ceQuery);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (this.alphabet.containsSymbol(symbol)) {
            return;
        }
        ((GrowableAlphabetAutomaton)this.internalHyp).addAlphabetSymbol(symbol);
        SymbolHidingAlphabet.runWhileHiding((Alphabet)this.alphabet, symbol, () -> super.addAlphabetSymbol(symbol));
        this.updateInternalHypothesis();
    }

    public AutomatonLStarState<I, D, AI, S> suspend() {
        return new AutomatonLStarState(this.table, this.internalHyp, this.stateInfos);
    }

    public void resume(AutomatonLStarState<I, D, AI, S> state) {
        this.table = state.getObservationTable();
        this.table.setInputAlphabet(this.alphabet);
        this.internalHyp = (MutableDeterministic)state.getHypothesis();
        this.stateInfos = state.getStateInfos();
    }

    static final class StateInfo<S, I>
    implements Serializable {
        private final Row<I> row;
        private final S state;

        StateInfo(Row<I> row, S state) {
            this.row = row;
            this.state = state;
        }

        public Row<I> getRow() {
            return this.row;
        }

        public S getState() {
            return this.state;
        }
    }
}

