/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric.table;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.lstargeneric.table.Inconsistency;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public final class ObservationTable<I, D>
implements AccessSequenceTransformer<I> {
    private static final int NO_ENTRY = -1;
    private final Alphabet<I> alphabet;
    private final List<Row<I>> shortPrefixRows = new ArrayList<Row<I>>();
    private final List<Row<I>> longPrefixRows = new ArrayList<Row<I>>();
    private final List<Row<I>> allRows = new ArrayList<Row<I>>();
    private final List<List<D>> allRowContents = new ArrayList<List<D>>();
    private final List<Row<I>> canonicalRows = new ArrayList<Row<I>>();
    private final TObjectIntMap<List<D>> rowContentIds = new TObjectIntHashMap(10, 0.75f, -1);
    private final Map<Word<I>, Row<I>> rowMap = new HashMap<Word<I>, Row<I>>();
    private int numRows = 0;
    private final List<Word<I>> suffixes = new ArrayList<Word<I>>();
    private final Set<Word<I>> suffixSet = new HashSet<Word<I>>();
    private boolean initialConsistencyCheckRequired = false;

    private static final <I> boolean checkPrefixClosed(Collection<? extends Word<I>> initialShortPrefixes) {
        HashSet<Word<I>> prefixes = new HashSet<Word<I>>(initialShortPrefixes);
        for (Word<I> pref : initialShortPrefixes) {
            if (pref.isEmpty() || prefixes.contains(pref.prefix(-1))) continue;
            return false;
        }
        return true;
    }

    public ObservationTable(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    public List<List<Row<I>>> initialize(List<Word<I>> initialShortPrefixes, List<Word<I>> initialSuffixes, MembershipOracle<I, D> oracle) {
        Row<I> succRow;
        if (this.allRows.size() > 0) {
            throw new IllegalStateException("Called initialize, but there are already rows present");
        }
        if (!ObservationTable.checkPrefixClosed(initialShortPrefixes)) {
            throw new IllegalArgumentException("Initial short prefixes are not prefix-closed");
        }
        if (!initialShortPrefixes.get(0).isEmpty()) {
            throw new IllegalArgumentException("First initial short prefix MUST be the empty word!");
        }
        int numSuffixes = initialSuffixes.size();
        for (Word<I> suffix : initialSuffixes) {
            if (!this.suffixSet.add(suffix)) continue;
            this.suffixes.add(suffix);
        }
        int numPrefixes = this.alphabet.size() * initialShortPrefixes.size() + 1;
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(numPrefixes * numSuffixes);
        for (Word<I> word : initialShortPrefixes) {
            this.createSpRow(word);
            ObservationTable.buildQueries(queries, word, this.suffixes);
        }
        for (Row row : this.shortPrefixRows) {
            Word word = row.getPrefix();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                Object sym = this.alphabet.getSymbol(i);
                Word lp = word.append(sym);
                succRow = this.rowMap.get(lp);
                if (succRow == null) {
                    succRow = this.createLpRow(lp);
                    ObservationTable.buildQueries(queries, lp, this.suffixes);
                }
                row.setSuccessor(i, succRow);
            }
        }
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, D>> queryIt = queries.iterator();
        for (Row<I> row : this.shortPrefixRows) {
            ArrayList rowContents = new ArrayList(numSuffixes);
            ObservationTable.fetchResults(queryIt, rowContents, numSuffixes);
            if (this.processContents(row, rowContents, true)) continue;
            this.initialConsistencyCheckRequired = true;
        }
        int n = this.numDistinctRows();
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        for (Row<I> spRow : this.shortPrefixRows) {
            for (int i = 0; i < this.alphabet.size(); ++i) {
                int id;
                succRow = spRow.getSuccessor(i);
                if (succRow.isShortPrefix()) continue;
                ArrayList rowContents = new ArrayList(numSuffixes);
                ObservationTable.fetchResults(queryIt, rowContents, numSuffixes);
                if (this.processContents(succRow, rowContents, false)) {
                    arrayList.add(new ArrayList());
                }
                if ((id = succRow.getRowContentId()) < n) continue;
                ((List)arrayList.get(id - n)).add(succRow);
            }
        }
        return arrayList;
    }

    public List<List<Row<I>>> addSuffix(Word<I> suffix, MembershipOracle<I, D> oracle) {
        return this.addSuffixes(Collections.singletonList(suffix), oracle);
    }

    public List<List<Row<I>>> addSuffixes(Collection<? extends Word<I>> newSuffixes, MembershipOracle<I, D> oracle) {
        int oldSuffixCount = this.suffixes.size();
        ArrayList<Word<I>> newSuffixList = new ArrayList<Word<I>>();
        for (Word<I> suffix : newSuffixes) {
            if (!this.suffixSet.add(suffix)) continue;
            newSuffixList.add(suffix);
        }
        if (newSuffixList.isEmpty()) {
            return Collections.emptyList();
        }
        int numNewSuffixes = newSuffixList.size();
        int numSpRows = this.shortPrefixRows.size();
        int rowCount = numSpRows + this.longPrefixRows.size();
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(rowCount * numNewSuffixes);
        for (Row<I> row : this.shortPrefixRows) {
            ObservationTable.buildQueries(queries, row.getPrefix(), newSuffixList);
        }
        for (Row<I> row : this.longPrefixRows) {
            ObservationTable.buildQueries(queries, row.getPrefix(), newSuffixList);
        }
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, D>> queryIt = queries.iterator();
        for (Row<I> row : this.shortPrefixRows) {
            List<D> rowContents = this.allRowContents.get(row.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                ObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, row.getRowContentId());
                continue;
            }
            ArrayList<D> newContents = new ArrayList<D>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            ObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            this.processContents(row, newContents, true);
        }
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        numSpRows = this.numDistinctRows();
        for (Row<I> row : this.longPrefixRows) {
            int id;
            List<D> rowContents = this.allRowContents.get(row.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                ObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, row.getRowContentId());
                continue;
            }
            ArrayList<D> newContents = new ArrayList<D>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            ObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            if (this.processContents(row, newContents, false)) {
                arrayList.add(new ArrayList());
            }
            if ((id = row.getRowContentId()) < numSpRows) continue;
            ((List)arrayList.get(id - numSpRows)).add(row);
        }
        this.suffixes.addAll(newSuffixList);
        return arrayList;
    }

    public boolean isInitialConsistencyCheckRequired() {
        return this.initialConsistencyCheckRequired;
    }

    public List<List<Row<I>>> toShortPrefixes(List<Row<I>> lpRows, MembershipOracle<I, D> oracle) {
        ArrayList<Row<I>> freshSpRows = new ArrayList<Row<I>>();
        ArrayList<Row<I>> freshLpRows = new ArrayList<Row<I>>();
        for (Row<I> row : lpRows) {
            if (row.isShortPrefix()) {
                if (row.hasContents()) continue;
                freshSpRows.add(row);
            } else {
                this.makeShort(row);
                if (!row.hasContents()) {
                    freshSpRows.add(row);
                }
            }
            Word<I> prefix = row.getPrefix();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                Iterator sym = this.alphabet.getSymbol(i);
                Word word = prefix.append((Object)sym);
                Row<I> lpRow = this.rowMap.get(word);
                if (lpRow == null) {
                    lpRow = this.createLpRow(word);
                    freshLpRows.add(lpRow);
                }
                row.setSuccessor(i, lpRow);
            }
        }
        int numSuffixes = this.suffixes.size();
        int numFreshRows = freshSpRows.size() + freshLpRows.size();
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(numFreshRows * numSuffixes);
        ObservationTable.buildRowQueries(queries, freshSpRows, this.suffixes);
        ObservationTable.buildRowQueries(queries, freshLpRows, this.suffixes);
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, D>> queryIt = queries.iterator();
        for (Row row : freshSpRows) {
            ArrayList contents = new ArrayList(numSuffixes);
            ObservationTable.fetchResults(queryIt, contents, numSuffixes);
            this.processContents(row, contents, true);
        }
        int numSpRows = this.numDistinctRows();
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        for (Row row : freshLpRows) {
            int id;
            ArrayList contents = new ArrayList(numSuffixes);
            ObservationTable.fetchResults(queryIt, contents, numSuffixes);
            if (this.processContents(row, contents, false)) {
                arrayList.add(new ArrayList());
            }
            if ((id = row.getRowContentId()) < numSpRows) continue;
            ((List)arrayList.get(id - numSpRows)).add(row);
        }
        return arrayList;
    }

    public Row<I> getRowSuccessor(Row<I> row, I sym) {
        return row.getSuccessor(this.alphabet.getSymbolIndex(sym));
    }

    public List<List<Row<I>>> addShortPrefixes(List<? extends Word<I>> shortPrefixes, MembershipOracle<I, D> oracle) {
        ArrayList<Row<I>> toSpRows = new ArrayList<Row<I>>();
        for (Word<I> sp : shortPrefixes) {
            Row<I> row = this.rowMap.get(sp);
            if (row != null) {
                if (row.isShortPrefix()) {
                    continue;
                }
            } else {
                row = this.createSpRow(sp);
            }
            toSpRows.add(row);
        }
        return this.toShortPrefixes(toSpRows, oracle);
    }

    public Inconsistency<I, D> findInconsistency() {
        Row[] canonicalRows = new Row[this.numDistinctRows()];
        for (Row<I> spRow : this.shortPrefixRows) {
            int contentId = spRow.getRowContentId();
            Row canRow = canonicalRows[contentId];
            if (canRow == null) {
                canonicalRows[contentId] = spRow;
                continue;
            }
            for (int i = 0; i < this.alphabet.size(); ++i) {
                int canSuccContent;
                int spSuccContent = spRow.getSuccessor(i).getRowContentId();
                if (spSuccContent == (canSuccContent = canRow.getSuccessor(i).getRowContentId())) continue;
                return new Inconsistency(canRow, spRow, i);
            }
        }
        return null;
    }

    protected boolean makeShort(Row<I> row) {
        int cid;
        if (row.isShortPrefix()) {
            return false;
        }
        int lastIdx = this.longPrefixRows.size() - 1;
        Row<I> last = this.longPrefixRows.get(lastIdx);
        int rowIdx = row.getLpIndex();
        this.longPrefixRows.remove(lastIdx);
        if (last != row) {
            this.longPrefixRows.set(rowIdx, last);
            last.setLpIndex(rowIdx);
        }
        this.shortPrefixRows.add(row);
        row.makeShort(this.alphabet.size());
        if (row.hasContents() && this.canonicalRows.get(cid = row.getRowContentId()) == null) {
            this.canonicalRows.set(cid, row);
        }
        return true;
    }

    protected Row<I> createLpRow(Word<I> prefix) {
        Row<I> newRow = new Row<I>(prefix, this.numRows++);
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        int idx = this.longPrefixRows.size();
        this.longPrefixRows.add(newRow);
        newRow.setLpIndex(idx);
        return newRow;
    }

    protected Row<I> createSpRow(Word<I> prefix) {
        Row<I> newRow = new Row<I>(prefix, this.numRows++, this.alphabet.size());
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        this.shortPrefixRows.add(newRow);
        return newRow;
    }

    public List<D> rowContents(Row<I> row) {
        return this.allRowContents.get(row.getRowContentId());
    }

    public D cellContents(Row<I> row, int columnId) {
        List<D> contents = this.rowContents(row);
        return contents.get(columnId);
    }

    public Row<I> getRow(int rowId) {
        return this.allRows.get(rowId);
    }

    public int numDistinctRows() {
        return this.allRowContents.size();
    }

    public List<Row<I>> getShortPrefixRows() {
        return this.shortPrefixRows;
    }

    public int numShortPrefixRows() {
        return this.shortPrefixRows.size();
    }

    public int numLongPrefixRows() {
        return this.longPrefixRows.size();
    }

    public int numTotalRows() {
        return this.shortPrefixRows.size() + this.longPrefixRows.size();
    }

    public int numSuffixes() {
        return this.suffixes.size();
    }

    public List<Word<I>> getSuffixes() {
        return this.suffixes;
    }

    protected boolean processContents(Row<I> row, List<D> rowContents, boolean makeCanonical) {
        boolean added = false;
        int contentId = this.rowContentIds.get(rowContents);
        if (contentId == -1) {
            contentId = this.numDistinctRows();
            this.rowContentIds.put(rowContents, contentId);
            this.allRowContents.add(rowContents);
            added = true;
            if (makeCanonical) {
                this.canonicalRows.add(row);
            } else {
                this.canonicalRows.add(null);
            }
        }
        row.setRowContentId(contentId);
        return added;
    }

    protected static <I, D> void buildQueries(List<DefaultQuery<I, D>> queryList, List<Word<I>> prefixes, List<? extends Word<I>> suffixes) {
        for (Word<I> prefix : prefixes) {
            ObservationTable.buildQueries(queryList, prefix, suffixes);
        }
    }

    protected static <I, D> void buildRowQueries(List<DefaultQuery<I, D>> queryList, List<Row<I>> rows, List<? extends Word<I>> suffixes) {
        for (Row<I> row : rows) {
            ObservationTable.buildQueries(queryList, row.getPrefix(), suffixes);
        }
    }

    protected static <I, D> void buildQueries(List<DefaultQuery<I, D>> queryList, Word<I> prefix, List<? extends Word<I>> suffixes) {
        for (Word<I> suffix : suffixes) {
            queryList.add(new DefaultQuery(prefix, suffix));
        }
    }

    protected static <I, D> void fetchResults(Iterator<DefaultQuery<I, D>> queryIt, List<D> output, int numSuffixes) {
        for (int j = 0; j < numSuffixes; ++j) {
            DefaultQuery<I, D> qry = queryIt.next();
            output.add(qry.getOutput());
        }
    }

    public boolean isInitialized() {
        return this.allRows.size() > 0;
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        Row<I> current = this.shortPrefixRows.get(0);
        for (Object sym : word) {
            current = this.getRowSuccessor(current, sym);
            current = this.canonicalRows.get(current.getRowContentId());
        }
        return current.getPrefix();
    }

    public boolean isAccessSequence(Word<I> word) {
        Row<I> current = this.shortPrefixRows.get(0);
        for (Object sym : word) {
            if (this.isCanonical(current = this.getRowSuccessor(current, sym))) continue;
            return false;
        }
        return true;
    }

    private boolean isCanonical(Row<I> row) {
        if (!row.isShortPrefix()) {
            return false;
        }
        int contentId = row.getRowContentId();
        return this.canonicalRows.get(contentId) == row;
    }

    private StandardRowWrapper wrapRow(Row<I> internalRow) {
        if (internalRow != null) {
            return new StandardRowWrapper(internalRow);
        }
        return null;
    }

    public de.learnlib.algorithms.features.observationtable.ObservationTable<I, D> asStandardTable() {
        final Function wrapRow = new Function<Row<I>, StandardRowWrapper>(){

            public StandardRowWrapper apply(Row<I> internalRow) {
                return ObservationTable.this.wrapRow(internalRow);
            }
        };
        return new de.learnlib.algorithms.features.observationtable.ObservationTable<I, D>(){

            public List<? extends Word<I>> getSuffixes() {
                return Collections.unmodifiableList(ObservationTable.this.suffixes);
            }

            public Collection<? extends ObservationTable.Row<I, D>> getShortPrefixRows() {
                return Collections.unmodifiableList(Lists.transform((List)ObservationTable.this.shortPrefixRows, (Function)wrapRow));
            }

            public Collection<? extends ObservationTable.Row<I, D>> getLongPrefixRows() {
                return Collections.unmodifiableList(Lists.transform((List)ObservationTable.this.longPrefixRows, (Function)wrapRow));
            }

            public ObservationTable.Row<I, D> getSuccessorRow(ObservationTable.Row<I, D> spRow, I symbol) {
                if (!(spRow instanceof StandardRowWrapper)) {
                    throw new IllegalArgumentException("Invalid observation table row");
                }
                StandardRowWrapper wrapped = (StandardRowWrapper)spRow;
                return ObservationTable.this.wrapRow(ObservationTable.this.getRowSuccessor(wrapped.internalRow, symbol));
            }

            public List<? extends ObservationTable.Row<I, D>> getAllRows() {
                return Collections.unmodifiableList(Lists.transform((List)ObservationTable.this.allRows, (Function)wrapRow));
            }

            public ObservationTable.Row<I, D> getRow(Word<I> prefix) {
                return ObservationTable.this.wrapRow((Row)ObservationTable.this.rowMap.get(prefix));
            }

            public Collection<? extends Word<I>> getAllPrefixes() {
                return Collections.unmodifiableSet(ObservationTable.this.rowMap.keySet());
            }
        };
    }

    private class StandardRowWrapper
    extends ObservationTable.AbstractRow<I, D> {
        private final Row<I> internalRow;

        public StandardRowWrapper(Row<I> internalRow) {
            this.internalRow = internalRow;
        }

        public Word<I> getLabel() {
            return this.internalRow.getPrefix();
        }

        public boolean isShortPrefixRow() {
            return this.internalRow.isShortPrefix();
        }

        public List<D> getContents() {
            return Collections.unmodifiableList((List)ObservationTable.this.allRowContents.get(this.internalRow.getRowContentId()));
        }
    }
}

