/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric.mealy;

import de.learnlib.algorithms.features.observationtable.OTLearner;
import de.learnlib.algorithms.lstargeneric.ExtensibleAutomatonLStar;
import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstargeneric.closing.ClosingStrategy;
import de.learnlib.algorithms.lstargeneric.mealy.LStarMealyUtil;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.automata.transout.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class ExtensibleLStarMealy<I, O>
extends ExtensibleAutomatonLStar<MealyMachine<?, I, ?, O>, I, Word<O>, Integer, CompactMealyTransition<O>, Void, O, CompactMealy<I, O>>
implements OTLearner.OTLearnerMealy<I, O> {
    private final List<O> outputTable = new ArrayList<O>();

    public ExtensibleLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super Word<O>> cexHandler, ClosingStrategy<? super I, ? super Word<O>> closingStrategy) {
        this(alphabet, oracle, Collections.singletonList(Word.epsilon()), initialSuffixes, cexHandler, closingStrategy);
    }

    public ExtensibleLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super Word<O>> cexHandler, ClosingStrategy<? super I, ? super Word<O>> closingStrategy) {
        super(alphabet, oracle, new CompactMealy(alphabet), initialPrefixes, LStarMealyUtil.ensureSuffixCompliancy(initialSuffixes, alphabet, cexHandler.needsConsistencyCheck()), cexHandler, closingStrategy);
    }

    @Override
    protected void updateInternalHypothesis() {
        this.updateOutputs();
        super.updateInternalHypothesis();
    }

    @Override
    protected Void stateProperty(Row<I> stateRow) {
        return null;
    }

    @Override
    protected O transitionProperty(Row<I> stateRow, int inputIdx) {
        Row<I> transRow = stateRow.getSuccessor(inputIdx);
        return this.outputTable.get(transRow.getRowId() - 1);
    }

    @Override
    protected List<Word<I>> initialSuffixes() {
        return this.initialSuffixes;
    }

    protected void updateOutputs() {
        int i;
        int numOutputs = this.outputTable.size();
        int numTransRows = this.table.numTotalRows() - 1;
        int newOutputs = numTransRows - numOutputs;
        if (newOutputs == 0) {
            return;
        }
        ArrayList<DefaultQuery> outputQueries = new ArrayList<DefaultQuery>(numOutputs);
        for (i = numOutputs + 1; i <= numTransRows; ++i) {
            Row row = this.table.getRow(i);
            Word rowPrefix = row.getPrefix();
            int prefixLen = rowPrefix.size();
            outputQueries.add(new DefaultQuery(rowPrefix.prefix(prefixLen - 1), rowPrefix.suffix(1)));
        }
        this.oracle.processQueries(outputQueries);
        for (i = 0; i < newOutputs; ++i) {
            DefaultQuery query = (DefaultQuery)outputQueries.get(i);
            Object outSym = ((Word)query.getOutput()).getSymbol(0);
            this.outputTable.add(outSym);
        }
    }

    @Override
    protected MealyMachine<?, I, ?, O> exposeInternalHypothesis() {
        return (MealyMachine)this.internalHyp;
    }

    @Override
    public CompactMealy<I, O> getHypothesisModel() {
        return (CompactMealy)this.internalHyp;
    }

    @Override
    protected SuffixOutput<I, Word<O>> hypothesisOutput() {
        return (SuffixOutput)this.internalHyp;
    }
}

