/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric.mealy;

import de.learnlib.algorithms.lstargeneric.ExtensibleAutomatonLStar;
import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstargeneric.closing.ClosingStrategy;
import de.learnlib.algorithms.lstargeneric.mealy.LStarMealyUtil;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import de.learnlib.mealy.MealyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.MutableMealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.automata.transout.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class ClassicLStarMealy<I, O>
extends ExtensibleAutomatonLStar<MealyMachine<?, I, ?, O>, I, O, Integer, CompactMealyTransition<O>, Void, O, CompactMealy<I, O>> {
    public static <A extends MutableMealyMachine<?, I, ?, O>, I, O> ClassicLStarMealy<I, O> createForSymbolOracle(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<I, O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        return new ClassicLStarMealy<I, O>(alphabet, oracle, initialSuffixes, cexHandler, closingStrategy);
    }

    public static <A extends MutableMealyMachine<?, I, ?, O>, I, O> ClassicLStarMealy<I, O> createForWordOracle(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        return new ClassicLStarMealy<I, O>(alphabet, MealyUtil.wrapWordOracle(oracle), initialSuffixes, cexHandler, closingStrategy);
    }

    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        this(alphabet, oracle, Collections.singletonList(Word.epsilon()), initialSuffixes, cexHandler, closingStrategy);
    }

    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        super(alphabet, oracle, new CompactMealy(alphabet), initialPrefixes, LStarMealyUtil.ensureSuffixCompliancy(initialSuffixes, alphabet, true), cexHandler, closingStrategy);
    }

    @Override
    protected Void stateProperty(Row<I> stateRow) {
        return null;
    }

    @Override
    protected O transitionProperty(Row<I> stateRow, int inputIdx) {
        return (O)this.table.cellContents(stateRow, inputIdx);
    }

    @Override
    protected List<Word<I>> initialSuffixes() {
        ArrayList<Word<I>> suffixes = new ArrayList<Word<I>>(this.alphabet.size());
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object sym = this.alphabet.getSymbol(i);
            suffixes.add(Word.fromLetter((Object)sym));
        }
        return suffixes;
    }

    @Override
    protected MealyMachine<?, I, ?, O> exposeInternalHypothesis() {
        return (MealyMachine)this.internalHyp;
    }

    @Override
    protected SuffixOutput<I, O> hypothesisOutput() {
        return new SuffixOutput<I, O>(){

            public O computeOutput(Iterable<? extends I> input) {
                return this.computeSuffixOutput(Collections.emptyList(), input);
            }

            public O computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
                Word wordOut = ((CompactMealy)ClassicLStarMealy.this.internalHyp).computeSuffixOutput(prefix, suffix);
                if (wordOut.isEmpty()) {
                    return null;
                }
                return wordOut.lastSymbol();
            }
        };
    }
}

