/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric;

import de.learnlib.algorithms.lstargeneric.AbstractAutomatonLStar;
import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandlers;
import de.learnlib.algorithms.lstargeneric.closing.ClosingStrategies;
import de.learnlib.algorithms.lstargeneric.closing.ClosingStrategy;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class ExtensibleAutomatonLStar<A, I, D, S, T, SP, TP, AI extends MutableDeterministic<S, I, T, SP, TP>>
extends AbstractAutomatonLStar<A, I, D, S, T, SP, TP, AI> {
    protected final ObservationTableCEXHandler<? super I, ? super D> cexHandler;
    protected final ClosingStrategy<? super I, ? super D> closingStrategy;
    protected final List<Word<I>> initialPrefixes;
    protected final List<Word<I>> initialSuffixes;

    public ExtensibleAutomatonLStar(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, AI internalHyp, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super D> cexHandler, ClosingStrategy<? super I, ? super D> closingStrategy) {
        super(alphabet, oracle, internalHyp);
        this.initialPrefixes = initialPrefixes;
        this.initialSuffixes = initialSuffixes;
        this.cexHandler = cexHandler;
        this.closingStrategy = closingStrategy;
    }

    @Override
    protected void refineHypothesisInternal(DefaultQuery<I, D> ceQuery) {
        List<List<Row<I>>> unclosed = this.cexHandler.handleCounterexample(ceQuery, this.table, this.hypothesisOutput(), this.oracle);
        this.completeConsistentTable(unclosed, this.cexHandler.needsConsistencyCheck());
    }

    @Override
    protected List<Row<I>> selectClosingRows(List<List<Row<I>>> unclosed) {
        return this.closingStrategy.selectClosingRows(unclosed, this.table, this.oracle);
    }

    @Override
    protected List<Word<I>> initialSuffixes() {
        return this.initialSuffixes;
    }

    @Override
    protected List<Word<I>> initialPrefixes() {
        return this.initialPrefixes;
    }

    public static final class BuilderDefaults {
        public static final <I> List<Word<I>> initialPrefixes() {
            return Collections.singletonList(Word.epsilon());
        }

        public static final <I> List<Word<I>> initialSuffixes() {
            return Collections.emptyList();
        }

        public static <I, D> ObservationTableCEXHandler<? super I, ? super D> cexHandler() {
            return ObservationTableCEXHandlers.CLASSIC_LSTAR;
        }

        public static <I, D> ClosingStrategy<? super I, ? super D> closingStrategy() {
            return ClosingStrategies.CLOSE_FIRST;
        }
    }
}

