/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric;

import de.learnlib.algorithms.features.globalsuffixes.GlobalSuffixLearner;
import de.learnlib.algorithms.features.observationtable.OTLearner;
import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandlers;
import de.learnlib.algorithms.lstargeneric.table.Inconsistency;
import de.learnlib.algorithms.lstargeneric.table.ObservationTable;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.oracles.MQUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class AbstractLStar<A, I, D>
implements OTLearner<A, I, D>,
GlobalSuffixLearner<A, I, D> {
    protected final Alphabet<? extends I> alphabet;
    protected final MembershipOracle<I, D> oracle;
    protected final ObservationTable<I, D> table;

    public AbstractLStar(Alphabet<I> alphabet, MembershipOracle<I, D> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.table = new ObservationTable(alphabet);
    }

    public void startLearning() {
        List<Word<I>> prefixes = this.initialPrefixes();
        List<Word<I>> suffixes = this.initialSuffixes();
        List<List<Row<I>>> initialUnclosed = this.table.initialize(prefixes, suffixes, this.oracle);
        this.completeConsistentTable(initialUnclosed, this.table.isInitialConsistencyCheckRequired());
    }

    public final boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        if (!MQUtil.isCounterexample(ceQuery, this.hypothesisOutput())) {
            return false;
        }
        int oldDistinctRows = this.table.numDistinctRows();
        this.doRefineHypothesis(ceQuery);
        assert (this.table.numDistinctRows() > oldDistinctRows);
        return true;
    }

    protected void doRefineHypothesis(DefaultQuery<I, D> ceQuery) {
        List<List<Row<I>>> unclosed = this.incorporateCounterExample(ceQuery);
        this.completeConsistentTable(unclosed, true);
    }

    protected boolean completeConsistentTable(List<List<Row<I>>> unclosed, boolean checkConsistency) {
        boolean refined = false;
        while (true) {
            if (!unclosed.isEmpty()) {
                List<Row<I>> closingRows = this.selectClosingRows(unclosed);
                unclosed = this.table.toShortPrefixes(closingRows, this.oracle);
                refined = true;
                continue;
            }
            if (checkConsistency) {
                Inconsistency<I, D> incons = null;
                do {
                    if ((incons = this.table.findInconsistency()) == null) continue;
                    Word<I> newSuffix = this.analyzeInconsistency(incons);
                    unclosed = this.table.addSuffix(newSuffix, this.oracle);
                } while (unclosed.isEmpty() && incons != null);
            }
            if (unclosed.isEmpty()) break;
        }
        return refined;
    }

    protected Word<I> analyzeInconsistency(Inconsistency<I, D> incons) {
        int inputIdx = incons.getInputIndex();
        Row<I> succRow1 = incons.getFirstRow().getSuccessor(inputIdx);
        Row<I> succRow2 = incons.getSecondRow().getSuccessor(inputIdx);
        int numSuffixes = this.table.numSuffixes();
        List<D> contents1 = this.table.rowContents(succRow1);
        List<D> contents2 = this.table.rowContents(succRow2);
        for (int i = 0; i < numSuffixes; ++i) {
            D val2;
            D val1 = contents1.get(i);
            if (Objects.equals(val1, val2 = contents2.get(i))) continue;
            Object sym = this.alphabet.getSymbol(inputIdx);
            Word<I> suffix = this.table.getSuffixes().get(i);
            return suffix.prepend(sym);
        }
        throw new IllegalArgumentException("Bogus inconsistency");
    }

    protected List<List<Row<I>>> incorporateCounterExample(DefaultQuery<I, D> ce) {
        return ObservationTableCEXHandlers.handleClassicLStar(ce, this.table, this.oracle);
    }

    protected List<Row<I>> selectClosingRows(List<List<Row<I>>> unclosed) {
        ArrayList<Row<I>> closingRows = new ArrayList<Row<I>>(unclosed.size());
        for (List<Row<I>> rowList : unclosed) {
            closingRows.add(rowList.get(0));
        }
        return closingRows;
    }

    protected abstract List<Word<I>> initialSuffixes();

    protected List<Word<I>> initialPrefixes() {
        return Collections.singletonList(Word.epsilon());
    }

    public Collection<? extends Word<I>> getGlobalSuffixes() {
        return Collections.unmodifiableCollection(this.table.getSuffixes());
    }

    public boolean addGlobalSuffixes(Collection<? extends Word<I>> newGlobalSuffixes) {
        List<List<Row<I>>> unclosed = this.table.addSuffixes(newGlobalSuffixes, this.oracle);
        if (unclosed.isEmpty()) {
            return false;
        }
        return this.completeConsistentTable(unclosed, false);
    }

    public de.learnlib.algorithms.features.observationtable.ObservationTable<I, D> getObservationTable() {
        return this.table.asStandardTable();
    }

    protected abstract SuffixOutput<I, D> hypothesisOutput();
}

