/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric;

import de.learnlib.algorithms.lstargeneric.AbstractLStar;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;

public abstract class AbstractAutomatonLStar<A, I, D, S, T, SP, TP, AI extends MutableDeterministic<S, I, T, SP, TP>>
extends AbstractLStar<A, I, D> {
    protected final AI internalHyp;
    protected final ArrayList<StateInfo<S, I>> stateInfos = new ArrayList();

    public AbstractAutomatonLStar(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, AI internalHyp) {
        super(alphabet, oracle);
        this.internalHyp = internalHyp;
        internalHyp.clear();
    }

    protected abstract SP stateProperty(Row<I> var1);

    protected abstract TP transitionProperty(Row<I> var1, int var2);

    protected abstract A exposeInternalHypothesis();

    protected void updateInternalHypothesis() {
        Object state;
        if (!this.table.isInitialized()) {
            throw new IllegalStateException("Cannot update internal hypothesis: not initialized");
        }
        int oldStates = this.internalHyp.size();
        int numDistinct = this.table.numDistinctRows();
        int newStates = numDistinct - oldStates;
        if (newStates <= 0) {
            return;
        }
        this.stateInfos.addAll(CollectionsUtil.nullList((int)newStates));
        for (Row row : this.table.getShortPrefixRows()) {
            int id = row.getRowContentId();
            StateInfo<S, I> info = this.stateInfos.get(id);
            if (info != null) {
                if (info.getRow() != row) continue;
                this.internalHyp.setStateProperty(info.getState(), this.stateProperty(row));
                continue;
            }
            state = this.createState(id == 0, row);
            this.stateInfos.set(id, new StateInfo(row, state));
        }
        for (StateInfo stateInfo : this.stateInfos) {
            Row sp = stateInfo.getRow();
            int rowId = sp.getRowContentId();
            state = stateInfo.getState();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                Object input = this.alphabet.getSymbol(i);
                Row succ = sp.getSuccessor(i);
                int succId = succ.getRowContentId();
                if (rowId < oldStates && succId < oldStates) continue;
                S succState = this.stateInfos.get(succId).getState();
                this.setTransition(state, input, succState, sp, i, succ);
            }
        }
    }

    protected S createState(boolean initial, Row<I> row) {
        SP prop = this.stateProperty(row);
        if (initial) {
            return (S)this.internalHyp.addInitialState(prop);
        }
        return (S)this.internalHyp.addState(prop);
    }

    protected void setTransition(S from, I input, S to, Row<I> fromRow, int inputIdx, Row<I> toRow) {
        TP prop = this.transitionProperty(fromRow, inputIdx);
        this.internalHyp.setTransition(from, input, to, prop);
    }

    public A getHypothesisModel() {
        return this.exposeInternalHypothesis();
    }

    @Override
    public final void startLearning() {
        super.startLearning();
        this.updateInternalHypothesis();
    }

    @Override
    protected final void doRefineHypothesis(DefaultQuery<I, D> ceQuery) {
        this.refineHypothesisInternal(ceQuery);
        this.updateInternalHypothesis();
    }

    protected void refineHypothesisInternal(DefaultQuery<I, D> ceQuery) {
        super.doRefineHypothesis(ceQuery);
    }

    private static final class StateInfo<S, I> {
        private final Row<I> row;
        private final S state;

        public StateInfo(Row<I> row, S state) {
            this.row = row;
            this.state = state;
        }

        public Row<I> getRow() {
            return this.row;
        }

        public S getState() {
            return this.state;
        }
    }
}

