/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.kv.mealy;

import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.analyzers.AcexAnalyzers;
import de.learnlib.acex.impl.AbstractBaseCounterexample;
import de.learnlib.algorithms.kv.StateInfo;
import de.learnlib.algorithms.kv.mealy.KearnsVaziraniMealyState;
import de.learnlib.api.Resumable;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.discriminationtree.MultiDTree;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import de.learnlib.datastructure.discriminationtree.model.LCAInfo;
import de.learnlib.util.mealy.MealyUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public class KearnsVaziraniMealy<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
SupportsGrowingAlphabet<I>,
Resumable<KearnsVaziraniMealyState<I, O>> {
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, Word<O>> oracle;
    private final boolean repeatedCounterexampleEvaluation;
    private final AcexAnalyzer ceAnalyzer;
    protected MultiDTree<I, Word<O>, StateInfo<I, Word<O>>> discriminationTree;
    protected List<StateInfo<I, Word<O>>> stateInfos = new ArrayList<StateInfo<I, Word<O>>>();
    private CompactMealy<I, O> hypothesis;

    public KearnsVaziraniMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, boolean repeatedCounterexampleEvaluation, AcexAnalyzer counterexampleAnalyzer) {
        this.alphabet = alphabet;
        this.hypothesis = new CompactMealy(alphabet);
        this.oracle = oracle;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
        this.discriminationTree = new MultiDTree(oracle);
        this.ceAnalyzer = counterexampleAnalyzer;
    }

    public void startLearning() {
        this.initialize();
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        Word output;
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not initialized");
        }
        Word input = ceQuery.getInput();
        if (!this.refineHypothesisSingle(input, output = (Word)ceQuery.getOutput())) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(input, output)) {
            }
        }
        return true;
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not started");
        }
        return this.hypothesis;
    }

    public MultiDTree<I, Word<O>, StateInfo<I, Word<O>>> getDiscriminationTree() {
        return this.discriminationTree;
    }

    private boolean refineHypothesisSingle(Word<I> input, Word<O> output) {
        int inputLen = input.length();
        if (inputLen < 2) {
            return false;
        }
        int mismatchIdx = MealyUtil.findMismatch(this.hypothesis, input, output);
        if (mismatchIdx == -1) {
            return false;
        }
        Word effInput = input.prefix(mismatchIdx + 1);
        Word effOutput = output.prefix(mismatchIdx + 1);
        KVAbstractCounterexample acex = new KVAbstractCounterexample(effInput, effOutput, this.oracle);
        int idx = this.ceAnalyzer.analyzeAbstractCounterexample((AbstractCounterexample)acex, 0);
        Word prefix = effInput.prefix(idx);
        StateInfo srcStateInfo = acex.getStateInfo(idx);
        Object sym = effInput.getSymbol(idx);
        LCAInfo lca = acex.getLCA(idx + 1);
        assert (lca != null);
        this.splitState(srcStateInfo, prefix, sym, lca);
        return true;
    }

    private void splitState(StateInfo<I, Word<O>> stateInfo, Word<I> newPrefix, I sym, LCAInfo<Word<O>, AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> separatorInfo) {
        Word<Object> newOut;
        Word<Object> oldOut;
        Word<I> newDiscriminator;
        int state = stateInfo.id;
        List<Long> oldIncoming = stateInfo.fetchIncoming();
        StateInfo<I, Word<O>> newStateInfo = this.createState(newPrefix);
        AbstractWordBasedDTNode stateLeaf = stateInfo.dtNode;
        AbstractWordBasedDTNode separator = (AbstractWordBasedDTNode)separatorInfo.leastCommonAncestor;
        if (separator == null) {
            newDiscriminator = Word.fromLetter(sym);
            oldOut = (Word<Object>)separatorInfo.subtree1Label;
            newOut = (Word<Object>)separatorInfo.subtree2Label;
        } else {
            newDiscriminator = this.newDiscriminator(sym, (Word)separator.getDiscriminator());
            Object transOut = this.hypothesis.getOutput((Object)state, sym);
            oldOut = this.newOutcome(transOut, (Word)separatorInfo.subtree1Label);
            newOut = this.newOutcome(transOut, (Word)separatorInfo.subtree2Label);
        }
        AbstractDTNode.SplitResult sr = stateLeaf.split(newDiscriminator, (Object)oldOut, (Object)newOut, newStateInfo);
        stateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeOld;
        newStateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeNew;
        this.initState(newStateInfo);
        this.updateTransitions(oldIncoming, stateLeaf);
    }

    private Word<O> newOutcome(O transOutput, Word<O> succOutcome) {
        return succOutcome.prepend(transOutput);
    }

    private void updateTransitions(List<Long> transList, AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>> oldDtTarget) {
        int numTrans = transList.size();
        ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(numTrans);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            StateInfo<I, Word<O>> sourceInfo = this.stateInfos.get(sourceState);
            Object symbol = this.alphabet.getSymbol(transIdx);
            transAs.add(sourceInfo.accessSequence.append(symbol));
        }
        List<StateInfo<I, Word<O>>> succs = this.sift(Collections.nCopies(numTrans, oldDtTarget), transAs);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            this.setTransition(sourceState, transIdx, succs.get(i), this.hypothesis.getTransition(sourceState, transIdx).getOutput());
        }
    }

    private Word<I> newDiscriminator(I symbol, Word<I> succDiscriminator) {
        return succDiscriminator.prepend(symbol);
    }

    private StateInfo<I, Word<O>> createInitialState() {
        int state = this.hypothesis.addIntInitialState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, Word.epsilon());
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private StateInfo<I, Word<O>> createState(Word<I> prefix) {
        int state = this.hypothesis.addIntState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, prefix);
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private void initialize() {
        StateInfo<I, Word<O>> init = this.createInitialState();
        ((AbstractWordBasedDTNode)this.discriminationTree.getRoot()).setData(init);
        init.dtNode = (AbstractWordBasedDTNode)this.discriminationTree.getRoot();
        this.initState(init);
    }

    private void initState(StateInfo<I, Word<O>> stateInfo) {
        int alphabetSize = this.alphabet.size();
        int state = stateInfo.id;
        Word accessSequence = stateInfo.accessSequence;
        ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(alphabetSize);
        ArrayList<DefaultQuery> outputQueries = new ArrayList<DefaultQuery>(alphabetSize);
        for (int i = 0; i < alphabetSize; ++i) {
            Object sym = this.alphabet.getSymbol(i);
            transAs.add(accessSequence.append(sym));
            outputQueries.add(new DefaultQuery(accessSequence, Word.fromLetter((Object)sym)));
        }
        List<StateInfo<I, Word<O>>> succs = this.sift(transAs);
        this.oracle.processQueries(outputQueries);
        for (int i = 0; i < alphabetSize; ++i) {
            this.setTransition(state, i, succs.get(i), ((Word)((DefaultQuery)outputQueries.get(i)).getOutput()).firstSymbol());
        }
    }

    private void setTransition(int state, int symIdx, StateInfo<I, Word<O>> succInfo, O output) {
        succInfo.addIncoming(state, symIdx);
        this.hypothesis.setTransition(state, symIdx, succInfo.id, output);
    }

    private List<StateInfo<I, Word<O>>> sift(List<Word<I>> prefixes) {
        return this.sift(Collections.nCopies(prefixes.size(), this.discriminationTree.getRoot()), prefixes);
    }

    private List<StateInfo<I, Word<O>>> sift(List<AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> starts, List<Word<I>> prefixes) {
        List leaves = this.discriminationTree.sift(starts, prefixes);
        ArrayList<StateInfo<I, Word<O>>> result = new ArrayList<StateInfo<I, Word<O>>>(leaves.size());
        for (int i = 0; i < leaves.size(); ++i) {
            AbstractWordBasedDTNode leaf = (AbstractWordBasedDTNode)leaves.get(i);
            StateInfo<I, Word<O>> succStateInfo = (StateInfo<I, Word<O>>)leaf.getData();
            if (succStateInfo == null) {
                succStateInfo = this.createState(prefixes.get(i));
                leaf.setData(succStateInfo);
                succStateInfo.dtNode = leaf;
                this.initState(succStateInfo);
            }
            result.add(succStateInfo);
        }
        return result;
    }

    public void addAlphabetSymbol(I symbol) throws GrowingAlphabetNotSupportedException {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor((Object)this.hypothesis.getInitialState(), symbol) == null) {
            ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(this.stateInfos.size());
            ArrayList<DefaultQuery> outputQueries = new ArrayList<DefaultQuery>(this.stateInfos.size());
            for (StateInfo<I, Word<O>> si : this.stateInfos) {
                transAs.add(si.accessSequence.append(symbol));
                outputQueries.add(new DefaultQuery(si.accessSequence, Word.fromLetter(symbol)));
            }
            List<StateInfo<I, Word<O>>> succs = this.sift(transAs);
            this.oracle.processQueries(outputQueries);
            Iterator<StateInfo<I, Word<O>>> stateIter = this.stateInfos.iterator();
            Iterator<StateInfo<I, Word<O>>> leafsIter = succs.iterator();
            Iterator outputsIter = outputQueries.iterator();
            int inputIdx = this.alphabet.getSymbolIndex(symbol);
            while (stateIter.hasNext() && leafsIter.hasNext()) {
                this.setTransition(stateIter.next().id, inputIdx, leafsIter.next(), ((Word)((DefaultQuery)outputsIter.next()).getOutput()).firstSymbol());
            }
        }
    }

    public KearnsVaziraniMealyState<I, O> suspend() {
        return new KearnsVaziraniMealyState<I, O>(this.hypothesis, this.discriminationTree, this.stateInfos);
    }

    public void resume(KearnsVaziraniMealyState<I, O> state) {
        this.hypothesis = state.getHypothesis();
        this.discriminationTree = state.getDiscriminationTree();
        this.discriminationTree.setOracle(this.oracle);
        this.stateInfos = state.getStateInfos();
    }

    protected class KVAbstractCounterexample
    extends AbstractBaseCounterexample<Boolean> {
        private final Word<I> ceWord;
        private final MembershipOracle<I, Word<O>> oracle;
        private final StateInfo<I, Word<O>>[] states;
        private final LCAInfo<Word<O>, AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>>[] lcas;

        public KVAbstractCounterexample(Word<I> ceWord, Word<O> output, MembershipOracle<I, Word<O>> oracle) {
            super(ceWord.length() + 1);
            this.ceWord = ceWord;
            this.oracle = oracle;
            int m = ceWord.length();
            this.states = new StateInfo[m + 1];
            this.lcas = new LCAInfo[m + 1];
            int currState = KearnsVaziraniMealy.this.hypothesis.getIntInitialState();
            int i = 0;
            this.states[i++] = KearnsVaziraniMealy.this.stateInfos.get(currState);
            for (Object sym : ceWord) {
                currState = KearnsVaziraniMealy.this.hypothesis.getSuccessor(currState, sym);
                this.states[i++] = KearnsVaziraniMealy.this.stateInfos.get(currState);
            }
            Object lastHypOut = KearnsVaziraniMealy.this.hypothesis.getOutput((Object)this.states[m - 1].id, ceWord.lastSymbol());
            this.lcas[m] = new LCAInfo(null, (Object)Word.fromLetter((Object)lastHypOut), (Object)Word.fromLetter((Object)output.lastSymbol()));
            super.setEffect(m, (Object)false);
        }

        public StateInfo<I, Word<O>> getStateInfo(int idx) {
            return this.states[idx];
        }

        public LCAInfo<Word<O>, AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> getLCA(int idx) {
            return this.lcas[idx];
        }

        protected Boolean computeEffect(int index) {
            Word prefix = this.ceWord.prefix(index);
            StateInfo info = this.states[index];
            AbstractWordBasedDTNode node = info.dtNode;
            ArrayDeque<Object> expect = new ArrayDeque<Object>();
            while (!node.isRoot()) {
                expect.push(node.getParentOutcome());
                node = (AbstractWordBasedDTNode)node.getParent();
            }
            AbstractWordBasedDTNode currNode = (AbstractWordBasedDTNode)KearnsVaziraniMealy.this.discriminationTree.getRoot();
            while (!expect.isEmpty()) {
                Word e;
                Word suffix = (Word)currNode.getDiscriminator();
                Word out = (Word)this.oracle.answerQuery(prefix, suffix);
                if (!Objects.equals(out, e = (Word)expect.pop())) {
                    this.lcas[index] = new LCAInfo((Object)currNode, (Object)e, (Object)out);
                    return false;
                }
                currNode = (AbstractWordBasedDTNode)currNode.child((Object)out);
            }
            assert (currNode.isLeaf() && expect.isEmpty());
            return true;
        }

        public boolean checkEffects(Boolean eff1, Boolean eff2) {
            return eff1 == false || eff2 != false;
        }
    }

    public static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }

        public static AcexAnalyzer counterexampleAnalyzer() {
            return AcexAnalyzers.LINEAR_FWD;
        }
    }
}

