/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.kv.dfa;

import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.analyzers.AcexAnalyzers;
import de.learnlib.acex.impl.AbstractBaseCounterexample;
import de.learnlib.algorithms.kv.StateInfo;
import de.learnlib.algorithms.kv.dfa.KearnsVaziraniDFAState;
import de.learnlib.api.Resumable;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.discriminationtree.BinaryDTree;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import de.learnlib.datastructure.discriminationtree.model.LCAInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.commons.smartcollections.ArrayStorage;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public class KearnsVaziraniDFA<I>
implements LearningAlgorithm.DFALearner<I>,
SupportsGrowingAlphabet<I>,
Resumable<KearnsVaziraniDFAState<I>> {
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, Boolean> oracle;
    private final boolean repeatedCounterexampleEvaluation;
    private final AcexAnalyzer ceAnalyzer;
    protected BinaryDTree<I, StateInfo<I, Boolean>> discriminationTree;
    protected List<StateInfo<I, Boolean>> stateInfos = new ArrayList<StateInfo<I, Boolean>>();
    private CompactDFA<I> hypothesis;

    public KearnsVaziraniDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, boolean repeatedCounterexampleEvaluation, AcexAnalyzer counterexampleAnalyzer) {
        this.alphabet = alphabet;
        this.hypothesis = new CompactDFA(alphabet);
        this.discriminationTree = new BinaryDTree(oracle);
        this.oracle = oracle;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
        this.ceAnalyzer = counterexampleAnalyzer;
    }

    public void startLearning() {
        this.initialize();
    }

    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        boolean output;
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not initialized");
        }
        Word input = ceQuery.getInput();
        if (!this.refineHypothesisSingle(input, output = ((Boolean)ceQuery.getOutput()).booleanValue())) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(input, output)) {
            }
        }
        return true;
    }

    public DFA<?, I> getHypothesisModel() {
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not started");
        }
        return this.hypothesis;
    }

    public BinaryDTree<I, StateInfo<I, Boolean>> getDiscriminationTree() {
        return this.discriminationTree;
    }

    private boolean refineHypothesisSingle(Word<I> input, boolean output) {
        int inputLen = input.length();
        if (inputLen < 2) {
            return false;
        }
        if (this.hypothesis.accepts(input) == output) {
            return false;
        }
        KVAbstractCounterexample acex = new KVAbstractCounterexample(input, output, this.oracle);
        int idx = this.ceAnalyzer.analyzeAbstractCounterexample((AbstractCounterexample)acex, 1);
        Word prefix = input.prefix(idx);
        StateInfo srcStateInfo = acex.getStateInfo(idx);
        Object sym = input.getSymbol(idx);
        LCAInfo lca = acex.getLCA(idx + 1);
        assert (lca != null);
        this.splitState(srcStateInfo, prefix, sym, lca);
        return true;
    }

    private void splitState(StateInfo<I, Boolean> stateInfo, Word<I> newPrefix, I sym, LCAInfo<Boolean, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>> separatorInfo) {
        int state = stateInfo.id;
        boolean oldAccepting = this.hypothesis.isAccepting(state);
        List<Long> oldIncoming = stateInfo.fetchIncoming();
        StateInfo<I, Boolean> newStateInfo = this.createState(newPrefix, oldAccepting);
        AbstractWordBasedDTNode stateLeaf = stateInfo.dtNode;
        AbstractWordBasedDTNode separator = (AbstractWordBasedDTNode)separatorInfo.leastCommonAncestor;
        Word<I> newDiscriminator = this.newDiscriminator(sym, (Word)separator.getDiscriminator());
        AbstractDTNode.SplitResult sr = stateLeaf.split(newDiscriminator, separatorInfo.subtree1Label, separatorInfo.subtree2Label, newStateInfo);
        stateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeOld;
        newStateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeNew;
        this.initState(newStateInfo);
        this.updateTransitions(oldIncoming, stateLeaf);
    }

    private void updateTransitions(List<Long> transList, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>> oldDtTarget) {
        int numTrans = transList.size();
        ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(numTrans);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            StateInfo<I, Boolean> sourceInfo = this.stateInfos.get(sourceState);
            Object symbol = this.alphabet.getSymbol(transIdx);
            transAs.add(sourceInfo.accessSequence.append(symbol));
        }
        List<StateInfo<I, Boolean>> succs = this.sift(Collections.nCopies(numTrans, oldDtTarget), transAs);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            this.setTransition(sourceState, transIdx, succs.get(i));
        }
    }

    private Word<I> newDiscriminator(I symbol, Word<I> succDiscriminator) {
        return succDiscriminator.prepend(symbol);
    }

    private void initialize() {
        boolean initAccepting = (Boolean)this.oracle.answerQuery(Word.epsilon());
        StateInfo<I, Boolean> initStateInfo = this.createInitialState(initAccepting);
        AbstractWordBasedDTNode root = (AbstractWordBasedDTNode)this.discriminationTree.getRoot();
        root.setData(initStateInfo);
        initStateInfo.dtNode = (AbstractWordBasedDTNode)root.split((Object)Word.epsilon(), (Object)Boolean.valueOf((boolean)initAccepting), (Object)Boolean.valueOf((boolean)(!initAccepting ? true : false))).nodeOld;
        this.initState(initStateInfo);
    }

    private StateInfo<I, Boolean> createInitialState(boolean accepting) {
        int state = this.hypothesis.addIntInitialState((Object)accepting);
        StateInfo si = new StateInfo(state, Word.epsilon());
        assert (this.stateInfos.size() == state);
        this.stateInfos.add(si);
        return si;
    }

    private StateInfo<I, Boolean> createState(Word<I> accessSequence, boolean accepting) {
        int state = this.hypothesis.addIntState((Object)accepting);
        StateInfo si = new StateInfo(state, accessSequence);
        assert (this.stateInfos.size() == state);
        this.stateInfos.add(si);
        return si;
    }

    private void initState(StateInfo<I, Boolean> stateInfo) {
        int alphabetSize = this.alphabet.size();
        int state = stateInfo.id;
        Word accessSequence = stateInfo.accessSequence;
        ArrayStorage transAs = new ArrayStorage(alphabetSize);
        for (int i = 0; i < alphabetSize; ++i) {
            Object sym = this.alphabet.getSymbol(i);
            transAs.set(i, (Object)accessSequence.append(sym));
        }
        List<StateInfo<I, Boolean>> succs = this.sift((List<Word<I>>)transAs);
        for (int i = 0; i < alphabetSize; ++i) {
            this.setTransition(state, i, succs.get(i));
        }
    }

    private void setTransition(int state, int symIdx, StateInfo<I, Boolean> succInfo) {
        succInfo.addIncoming(state, symIdx);
        this.hypothesis.setTransition(state, symIdx, succInfo.id);
    }

    private List<StateInfo<I, Boolean>> sift(List<Word<I>> prefixes) {
        return this.sift(Collections.nCopies(prefixes.size(), this.discriminationTree.getRoot()), prefixes);
    }

    private List<StateInfo<I, Boolean>> sift(List<AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>> starts, List<Word<I>> prefixes) {
        List leaves = this.discriminationTree.sift(starts, prefixes);
        ArrayStorage result = new ArrayStorage(leaves.size());
        for (int i = 0; i < leaves.size(); ++i) {
            AbstractWordBasedDTNode leaf = (AbstractWordBasedDTNode)leaves.get(i);
            StateInfo<I, Boolean> succStateInfo = (StateInfo<I, Boolean>)leaf.getData();
            if (succStateInfo == null) {
                boolean initAccepting;
                succStateInfo = this.createState(prefixes.get(i), !(initAccepting = this.hypothesis.isAccepting(this.hypothesis.getIntInitialState())));
                leaf.setData(succStateInfo);
                succStateInfo.dtNode = leaf;
                this.initState(succStateInfo);
            }
            result.set(i, (Object)succStateInfo);
        }
        return result;
    }

    public void addAlphabetSymbol(I symbol) throws GrowingAlphabetNotSupportedException {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor((Object)this.hypothesis.getInitialState(), symbol) == null) {
            ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(this.stateInfos.size());
            for (StateInfo<I, Boolean> si : this.stateInfos) {
                transAs.add(si.accessSequence.append(symbol));
            }
            List<StateInfo<I, Boolean>> succs = this.sift(transAs);
            Iterator<StateInfo<I, Boolean>> stateIter = this.stateInfos.iterator();
            Iterator<StateInfo<I, Boolean>> leafsIter = succs.iterator();
            int inputIdx = this.alphabet.getSymbolIndex(symbol);
            while (stateIter.hasNext() && leafsIter.hasNext()) {
                this.setTransition(stateIter.next().id, inputIdx, leafsIter.next());
            }
            assert (!stateIter.hasNext());
            assert (!leafsIter.hasNext());
        }
    }

    public KearnsVaziraniDFAState<I> suspend() {
        return new KearnsVaziraniDFAState<I>(this.hypothesis, this.discriminationTree, this.stateInfos);
    }

    public void resume(KearnsVaziraniDFAState<I> state) {
        this.hypothesis = state.getHypothesis();
        this.discriminationTree = state.getDiscriminationTree();
        this.discriminationTree.setOracle(this.oracle);
        this.stateInfos = state.getStateInfos();
    }

    protected class KVAbstractCounterexample
    extends AbstractBaseCounterexample<Boolean> {
        private final Word<I> ceWord;
        private final MembershipOracle<I, Boolean> oracle;
        private final StateInfo<I, Boolean>[] states;
        private final LCAInfo<Boolean, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>>[] lcas;

        public KVAbstractCounterexample(Word<I> ceWord, boolean output, MembershipOracle<I, Boolean> oracle) {
            super(ceWord.length() + 1);
            this.ceWord = ceWord;
            this.oracle = oracle;
            int m = ceWord.length();
            this.states = new StateInfo[m + 1];
            this.lcas = new LCAInfo[m + 1];
            int i = 0;
            int currState = KearnsVaziraniDFA.this.hypothesis.getIntInitialState();
            this.states[i++] = KearnsVaziraniDFA.this.stateInfos.get(currState);
            for (Object sym : ceWord) {
                currState = KearnsVaziraniDFA.this.hypothesis.getSuccessor(currState, sym);
                this.states[i++] = KearnsVaziraniDFA.this.stateInfos.get(currState);
            }
            this.lcas[m] = new LCAInfo((Object)KearnsVaziraniDFA.this.discriminationTree.getRoot(), (Object)(!output ? 1 : 0), (Object)output);
        }

        public StateInfo<I, Boolean> getStateInfo(int idx) {
            return this.states[idx];
        }

        public LCAInfo<Boolean, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>> getLCA(int idx) {
            return this.lcas[idx];
        }

        protected Boolean computeEffect(int index) {
            Word prefix = this.ceWord.prefix(index);
            StateInfo info = this.states[index];
            AbstractWordBasedDTNode node = info.dtNode;
            ArrayDeque<Object> expect = new ArrayDeque<Object>();
            while (!node.isRoot()) {
                expect.push(node.getParentOutcome());
                node = (AbstractWordBasedDTNode)node.getParent();
            }
            AbstractWordBasedDTNode currNode = (AbstractWordBasedDTNode)KearnsVaziraniDFA.this.discriminationTree.getRoot();
            while (!expect.isEmpty()) {
                Word suffix = (Word)currNode.getDiscriminator();
                boolean out = (Boolean)this.oracle.answerQuery(prefix, suffix);
                if (out != (Boolean)expect.pop()) {
                    this.lcas[index] = new LCAInfo((Object)currNode, (Object)(!out ? 1 : 0), (Object)out);
                    return false;
                }
                currNode = (AbstractWordBasedDTNode)currNode.child((Object)out);
            }
            assert (currNode.isLeaf() && expect.isEmpty());
            return true;
        }

        public boolean checkEffects(Boolean eff1, Boolean eff2) {
            return eff1 == false || eff2 != false;
        }
    }

    public static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }

        public static AcexAnalyzer counterexampleAnalyzer() {
            return AcexAnalyzers.LINEAR_FWD;
        }
    }
}

