/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.kv.mealy;

import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.analyzers.AcexAnalyzers;
import de.learnlib.acex.impl.BaseAbstractCounterexample;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.discriminationtree.DTNode;
import de.learnlib.discriminationtree.DiscriminationTree;
import de.learnlib.discriminationtree.MultiDTree;
import de.learnlib.mealy.MealyUtil;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.oracles.MQUtil;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.automata.transout.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class KearnsVaziraniMealy<I, O>
implements LearningAlgorithm.MealyLearner<I, O> {
    private static final TLongList EMPTY_LONG_LIST = new TLongArrayList(0);
    private final Alphabet<I> alphabet;
    private final CompactMealy<I, O> hypothesis;
    private final MembershipOracle<I, Word<O>> oracle;
    private final boolean repeatedCounterexampleEvaluation;
    private final DiscriminationTree<I, Word<O>, StateInfo<I, O>> discriminationTree;
    private final List<StateInfo<I, O>> stateInfos = new ArrayList<StateInfo<I, O>>();
    private final AcexAnalyzer ceAnalyzer;

    public KearnsVaziraniMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, boolean repeatedCounterexampleEvaluation, AcexAnalyzer counterexampleAnalyzer) {
        this.alphabet = alphabet;
        this.hypothesis = new CompactMealy(alphabet);
        this.oracle = oracle;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
        this.discriminationTree = new MultiDTree(oracle);
        this.ceAnalyzer = counterexampleAnalyzer;
    }

    public void startLearning() {
        this.initialize();
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        Word output;
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not initialized");
        }
        Word input = ceQuery.getInput();
        if (!this.refineHypothesisSingle(input, output = (Word)ceQuery.getOutput())) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(input, output)) {
            }
        }
        return true;
    }

    private boolean refineHypothesisSingle(Word<I> input, Word<O> output) {
        int inputLen = input.length();
        if (inputLen < 2) {
            return false;
        }
        int mismatchIdx = MealyUtil.findMismatch(this.hypothesis, input, output);
        if (mismatchIdx == -1) {
            return false;
        }
        Word effInput = input.prefix(mismatchIdx + 1);
        Word effOutput = output.prefix(mismatchIdx + 1);
        KVAbstractCounterexample acex = new KVAbstractCounterexample(effInput, effOutput, this.oracle);
        int idx = this.ceAnalyzer.analyzeAbstractCounterexample((AbstractCounterexample)acex, 0);
        Word prefix = effInput.prefix(idx);
        StateInfo srcStateInfo = acex.getStateInfo(idx);
        Object sym = effInput.getSymbol(idx);
        DiscriminationTree.LCAInfo lca = acex.getLCA(idx + 1);
        assert (lca != null);
        this.splitState(srcStateInfo, prefix, sym, lca);
        return true;
    }

    private void splitState(StateInfo<I, O> stateInfo, Word<I> newPrefix, I sym, DiscriminationTree.LCAInfo<I, Word<O>, StateInfo<I, O>> separatorInfo) {
        Word<Object> newOut;
        Word<Object> oldOut;
        Word<I> newDiscriminator;
        int state = stateInfo.id;
        TLongList oldIncoming = stateInfo.fetchIncoming();
        StateInfo<I, O> newStateInfo = this.createState(newPrefix);
        DTNode stateLeaf = stateInfo.dtNode;
        DTNode separator = separatorInfo.leastCommonAncestor;
        if (separator == null) {
            newDiscriminator = Word.fromLetter(sym);
            oldOut = (Word<Object>)separatorInfo.subtree1Label;
            newOut = (Word<Object>)separatorInfo.subtree2Label;
        } else {
            newDiscriminator = this.newDiscriminator(sym, separator.getDiscriminator());
            Object transOut = this.hypothesis.getOutput((Object)state, sym);
            oldOut = this.newOutcome(transOut, (Word)separatorInfo.subtree1Label);
            newOut = this.newOutcome(transOut, (Word)separatorInfo.subtree2Label);
        }
        DTNode.SplitResult split = stateLeaf.split(newDiscriminator, (Object)oldOut, (Object)newOut, newStateInfo);
        stateInfo.dtNode = split.nodeOld;
        newStateInfo.dtNode = split.nodeNew;
        this.initState(newStateInfo);
        this.updateTransitions(oldIncoming, stateLeaf);
    }

    private Word<O> newOutcome(O transOutput, Word<O> succOutcome) {
        return succOutcome.prepend(transOutput);
    }

    private void updateTransitions(TLongList transList, DTNode<I, Word<O>, StateInfo<I, O>> oldDtTarget) {
        int numTrans = transList.size();
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)(encodedTrans & 0xFFFFFFFFFFFFFFFFL);
            StateInfo<I, O> sourceInfo = this.stateInfos.get(sourceState);
            Object symbol = this.alphabet.getSymbol(transIdx);
            StateInfo<I, O> succInfo = this.sift(oldDtTarget, sourceInfo.accessSequence.append(symbol));
            Object output = ((CompactMealyTransition)this.hypothesis.getTransition(sourceState, transIdx)).getOutput();
            this.setTransition(sourceState, transIdx, succInfo, output);
        }
    }

    private Word<I> newDiscriminator(I symbol, Word<I> succDiscriminator) {
        return succDiscriminator.prepend(symbol);
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not started");
        }
        return this.hypothesis;
    }

    private StateInfo<I, O> createInitialState() {
        int state = this.hypothesis.addIntInitialState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, Word.epsilon());
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private StateInfo<I, O> createState(Word<I> prefix) {
        int state = this.hypothesis.addIntState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, prefix);
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private void initialize() {
        StateInfo<I, O> init = this.createInitialState();
        this.discriminationTree.getRoot().setData(init);
        init.dtNode = this.discriminationTree.getRoot();
        this.initState(init);
    }

    private void initState(StateInfo<I, O> stateInfo) {
        int alphabetSize = this.alphabet.size();
        int state = stateInfo.id;
        Word accessSequence = stateInfo.accessSequence;
        for (int i = 0; i < alphabetSize; ++i) {
            Object sym = this.alphabet.getSymbol(i);
            Object output = ((Word)MQUtil.output(this.oracle, accessSequence, (Word)Word.fromLetter((Object)sym))).firstSymbol();
            Word transAs = accessSequence.append(sym);
            StateInfo<I, O> succInfo = this.sift(transAs);
            this.setTransition(state, i, succInfo, output);
        }
    }

    private void setTransition(int state, int symIdx, StateInfo<I, O> succInfo, O output) {
        succInfo.addIncoming(state, symIdx);
        this.hypothesis.setTransition(state, symIdx, succInfo.id, output);
    }

    private StateInfo<I, O> sift(Word<I> prefix) {
        return this.sift(this.discriminationTree.getRoot(), prefix);
    }

    private StateInfo<I, O> sift(DTNode<I, Word<O>, StateInfo<I, O>> start, Word<I> prefix) {
        DTNode leaf = this.discriminationTree.sift(start, prefix);
        StateInfo<I, O> succStateInfo = (StateInfo<I, O>)leaf.getData();
        if (succStateInfo == null) {
            succStateInfo = this.createState(prefix);
            leaf.setData(succStateInfo);
            succStateInfo.dtNode = leaf;
            this.initState(succStateInfo);
        }
        return succStateInfo;
    }

    private class KVAbstractCounterexample
    extends BaseAbstractCounterexample {
        private final Word<I> ceWord;
        private final MembershipOracle<I, Word<O>> oracle;
        private final StateInfo<I, O>[] states;
        private final DiscriminationTree.LCAInfo<I, Word<O>, StateInfo<I, O>>[] lcas;

        public KVAbstractCounterexample(Word<I> ceWord, Word<O> output, MembershipOracle<I, Word<O>> oracle) {
            super(ceWord.length());
            this.ceWord = ceWord;
            this.oracle = oracle;
            int m = ceWord.length();
            this.states = new StateInfo[m + 1];
            this.lcas = new DiscriminationTree.LCAInfo[m + 1];
            int currState = KearnsVaziraniMealy.this.hypothesis.getIntInitialState();
            int i = 0;
            this.states[i++] = (StateInfo)KearnsVaziraniMealy.this.stateInfos.get(currState);
            for (Object sym : ceWord) {
                currState = (Integer)KearnsVaziraniMealy.this.hypothesis.getSuccessor((Object)currState, sym);
                this.states[i++] = (StateInfo)KearnsVaziraniMealy.this.stateInfos.get(currState);
            }
            Object lastHypOut = KearnsVaziraniMealy.this.hypothesis.getOutput((Object)this.states[m - 1].id, ceWord.lastSymbol());
            this.lcas[m] = new DiscriminationTree.LCAInfo(null, (Object)Word.fromLetter((Object)lastHypOut), (Object)Word.fromLetter((Object)output.lastSymbol()));
        }

        public StateInfo<I, O> getStateInfo(int idx) {
            return this.states[idx];
        }

        public DiscriminationTree.LCAInfo<I, Word<O>, StateInfo<I, O>> getLCA(int idx) {
            return this.lcas[idx];
        }

        protected int computeEffect(int index) {
            Word prefix = this.ceWord.prefix(index);
            StateInfo info = this.states[index];
            DTNode node = info.dtNode;
            ArrayDeque<Object> expect = new ArrayDeque<Object>();
            while (!node.isRoot()) {
                expect.push(node.getParentOutcome());
                node = node.getParent();
            }
            DTNode currNode = KearnsVaziraniMealy.this.discriminationTree.getRoot();
            while (!expect.isEmpty()) {
                Word e;
                Word suffix = currNode.getDiscriminator();
                Word out = (Word)MQUtil.output(this.oracle, (Word)prefix, (Word)suffix);
                if (!Objects.equals(out, e = (Word)expect.pop())) {
                    this.lcas[index] = new DiscriminationTree.LCAInfo(currNode, (Object)e, (Object)out);
                    return 1;
                }
                currNode = currNode.child((Object)out);
            }
            assert (currNode.isLeaf() && expect.isEmpty());
            return 0;
        }
    }

    private static final class StateInfo<I, O> {
        public final int id;
        public final Word<I> accessSequence;
        public DTNode<I, Word<O>, StateInfo<I, O>> dtNode;
        private TLongList incoming;

        public StateInfo(int id, Word<I> accessSequence) {
            this.accessSequence = accessSequence.trimmed();
            this.id = id;
        }

        public void addIncoming(int sourceState, int transIdx) {
            long encodedTrans = (long)sourceState << 32 | (long)transIdx;
            if (this.incoming == null) {
                this.incoming = new TLongArrayList();
            }
            this.incoming.add(encodedTrans);
        }

        public TLongList fetchIncoming() {
            if (this.incoming == null || this.incoming.isEmpty()) {
                return EMPTY_LONG_LIST;
            }
            TLongList result = this.incoming;
            this.incoming = null;
            return result;
        }
    }

    static final class BuilderDefaults {
        BuilderDefaults() {
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }

        public static AcexAnalyzer counterexampleAnalyzer() {
            return AcexAnalyzers.LINEAR_FWD;
        }
    }
}

