/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.kv.dfa;

import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.analyzers.AcexAnalyzers;
import de.learnlib.acex.impl.BaseAbstractCounterexample;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.discriminationtree.BinaryDTree;
import de.learnlib.discriminationtree.DTNode;
import de.learnlib.discriminationtree.DiscriminationTree;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.oracles.MQUtil;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class KearnsVaziraniDFA<I>
implements LearningAlgorithm.DFALearner<I> {
    private static final TLongList EMPTY_LONG_LIST = new TLongArrayList(0);
    private final Alphabet<I> alphabet;
    private final CompactDFA<I> hypothesis;
    private final MembershipOracle<I, Boolean> oracle;
    private final boolean repeatedCounterexampleEvaluation;
    private final BinaryDTree<I, StateInfo<I>> discriminationTree;
    private final List<StateInfo<I>> stateInfos = new ArrayList<StateInfo<I>>();
    private final AcexAnalyzer ceAnalyzer;

    public KearnsVaziraniDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, boolean repeatedCounterexampleEvaluation, AcexAnalyzer counterexampleAnalyzer) {
        this.alphabet = alphabet;
        this.hypothesis = new CompactDFA(alphabet);
        this.discriminationTree = new BinaryDTree(oracle);
        this.oracle = oracle;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
        this.ceAnalyzer = counterexampleAnalyzer;
    }

    public void startLearning() {
        this.initialize();
    }

    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        boolean output;
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not initialized");
        }
        Word input = ceQuery.getInput();
        if (!this.refineHypothesisSingle(input, output = ((Boolean)ceQuery.getOutput()).booleanValue())) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(input, output)) {
            }
        }
        return true;
    }

    private boolean refineHypothesisSingle(Word<I> input, boolean output) {
        int inputLen = input.length();
        if (inputLen < 2) {
            return false;
        }
        if (this.hypothesis.accepts(input) == output) {
            return false;
        }
        KVAbstractCounterexample acex = new KVAbstractCounterexample(input, output, this.oracle);
        int idx = this.ceAnalyzer.analyzeAbstractCounterexample((AbstractCounterexample)acex, 1);
        Word prefix = input.prefix(idx);
        StateInfo srcStateInfo = acex.getStateInfo(idx);
        Object sym = input.getSymbol(idx);
        DiscriminationTree.LCAInfo lca = acex.getLCA(idx + 1);
        assert (lca != null);
        this.splitState(srcStateInfo, prefix, sym, lca);
        return true;
    }

    private void splitState(StateInfo<I> stateInfo, Word<I> newPrefix, I sym, DiscriminationTree.LCAInfo<I, Boolean, StateInfo<I>> separatorInfo) {
        int state = stateInfo.id;
        boolean oldAccepting = this.hypothesis.isAccepting(state);
        TLongList oldIncoming = stateInfo.fetchIncoming();
        StateInfo<I> newStateInfo = this.createState(newPrefix, oldAccepting);
        DTNode stateLeaf = ((StateInfo)stateInfo).dtNode;
        DTNode separator = separatorInfo.leastCommonAncestor;
        Word<I> newDiscriminator = this.newDiscriminator(sym, separator.getDiscriminator());
        DTNode.SplitResult split = stateLeaf.split(newDiscriminator, separatorInfo.subtree1Label, separatorInfo.subtree2Label, newStateInfo);
        ((StateInfo)stateInfo).dtNode = split.nodeOld;
        ((StateInfo)newStateInfo).dtNode = split.nodeNew;
        this.initState(newStateInfo);
        this.updateTransitions(oldIncoming, stateLeaf);
    }

    private void updateTransitions(TLongList transList, DTNode<I, Boolean, StateInfo<I>> oldDtTarget) {
        int numTrans = transList.size();
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)(encodedTrans & 0xFFFFFFFFFFFFFFFFL);
            StateInfo<I> sourceInfo = this.stateInfos.get(sourceState);
            Object symbol = this.alphabet.getSymbol(transIdx);
            StateInfo<I> succ = this.sift(oldDtTarget, sourceInfo.accessSequence.append(symbol));
            this.setTransition(sourceState, transIdx, succ);
        }
    }

    private Word<I> newDiscriminator(I symbol, Word<I> succDiscriminator) {
        return succDiscriminator.prepend(symbol);
    }

    public DFA<?, I> getHypothesisModel() {
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not started");
        }
        return this.hypothesis;
    }

    private void initialize() {
        boolean initAccepting = (Boolean)MQUtil.output(this.oracle, (Word)Word.epsilon());
        StateInfo<I> initStateInfo = this.createInitialState(initAccepting);
        DTNode root = this.discriminationTree.getRoot();
        root.setData(initStateInfo);
        ((StateInfo)initStateInfo).dtNode = root.split((Word)Word.epsilon(), (Object)Boolean.valueOf((boolean)initAccepting), (Object)Boolean.valueOf((boolean)(!initAccepting ? true : false)), null).nodeOld;
        this.initState(initStateInfo);
    }

    private StateInfo<I> createInitialState(boolean accepting) {
        int state = this.hypothesis.addIntInitialState((Object)accepting);
        StateInfo si = new StateInfo(state, Word.epsilon());
        assert (this.stateInfos.size() == state);
        this.stateInfos.add(si);
        return si;
    }

    private StateInfo<I> createState(Word<I> accessSequence, boolean accepting) {
        int state = this.hypothesis.addIntState((Object)accepting);
        StateInfo<I> si = new StateInfo<I>(state, accessSequence);
        assert (this.stateInfos.size() == state);
        this.stateInfos.add(si);
        return si;
    }

    private void initState(StateInfo<I> stateInfo) {
        int alphabetSize = this.alphabet.size();
        int state = stateInfo.id;
        Word accessSequence = stateInfo.accessSequence;
        for (int i = 0; i < alphabetSize; ++i) {
            Object sym = this.alphabet.getSymbol(i);
            Word transAs = accessSequence.append(sym);
            StateInfo<I> succ = this.sift(transAs);
            this.setTransition(state, i, succ);
        }
    }

    private void setTransition(int state, int symIdx, StateInfo<I> succInfo) {
        succInfo.addIncoming(state, symIdx);
        this.hypothesis.setTransition(state, symIdx, succInfo.id);
    }

    private StateInfo<I> sift(Word<I> prefix) {
        return this.sift(this.discriminationTree.getRoot(), prefix);
    }

    private StateInfo<I> sift(DTNode<I, Boolean, StateInfo<I>> start, Word<I> prefix) {
        DTNode leaf = this.discriminationTree.sift(start, prefix);
        StateInfo<I> succStateInfo = (StateInfo<I>)leaf.getData();
        if (succStateInfo == null) {
            boolean initAccepting = this.hypothesis.isAccepting(this.hypothesis.getIntInitialState());
            succStateInfo = this.createState(prefix, !initAccepting);
            leaf.setData(succStateInfo);
            ((StateInfo)succStateInfo).dtNode = leaf;
            this.initState(succStateInfo);
        }
        return succStateInfo;
    }

    private class KVAbstractCounterexample
    extends BaseAbstractCounterexample {
        private final Word<I> ceWord;
        private final MembershipOracle<I, Boolean> oracle;
        private final StateInfo<I>[] states;
        private final DiscriminationTree.LCAInfo<I, Boolean, StateInfo<I>>[] lcas;

        public KVAbstractCounterexample(Word<I> ceWord, boolean output, MembershipOracle<I, Boolean> oracle) {
            super(ceWord.length());
            this.ceWord = ceWord;
            this.oracle = oracle;
            int m = ceWord.length();
            this.states = new StateInfo[m + 1];
            this.lcas = new DiscriminationTree.LCAInfo[m + 1];
            int i = 0;
            int currState = KearnsVaziraniDFA.this.hypothesis.getIntInitialState();
            this.states[i++] = (StateInfo)KearnsVaziraniDFA.this.stateInfos.get(currState);
            for (Object sym : ceWord) {
                currState = (Integer)KearnsVaziraniDFA.this.hypothesis.getSuccessor((Object)currState, sym);
                this.states[i++] = (StateInfo)KearnsVaziraniDFA.this.stateInfos.get(currState);
            }
            this.lcas[m] = new DiscriminationTree.LCAInfo(KearnsVaziraniDFA.this.discriminationTree.getRoot(), (Object)(!output ? 1 : 0), (Object)output);
        }

        public StateInfo<I> getStateInfo(int idx) {
            return this.states[idx];
        }

        public DiscriminationTree.LCAInfo<I, Boolean, StateInfo<I>> getLCA(int idx) {
            return this.lcas[idx];
        }

        protected int computeEffect(int index) {
            Word prefix = this.ceWord.prefix(index);
            StateInfo info = this.states[index];
            DTNode node = info.dtNode;
            ArrayDeque<Object> expect = new ArrayDeque<Object>();
            while (!node.isRoot()) {
                expect.push(node.getParentOutcome());
                node = node.getParent();
            }
            DTNode currNode = KearnsVaziraniDFA.this.discriminationTree.getRoot();
            while (!expect.isEmpty()) {
                Word suffix = currNode.getDiscriminator();
                boolean out = (Boolean)MQUtil.output(this.oracle, (Word)prefix, (Word)suffix);
                if (out != (Boolean)expect.pop()) {
                    this.lcas[index] = new DiscriminationTree.LCAInfo(currNode, (Object)(!out ? 1 : 0), (Object)out);
                    return 1;
                }
                currNode = currNode.child((Object)out);
            }
            assert (currNode.isLeaf() && expect.isEmpty());
            return 0;
        }
    }

    private static final class StateInfo<I> {
        public final int id;
        public final Word<I> accessSequence;
        private DTNode<I, Boolean, StateInfo<I>> dtNode;
        private TLongList incoming;

        public StateInfo(int id, Word<I> accessSequence) {
            this.id = id;
            this.accessSequence = accessSequence.trimmed();
        }

        public void addIncoming(int sourceState, int transIdx) {
            long encodedTrans = (long)sourceState << 32 | (long)transIdx;
            if (this.incoming == null) {
                this.incoming = new TLongArrayList();
            }
            this.incoming.add(encodedTrans);
        }

        public TLongList fetchIncoming() {
            if (this.incoming == null || this.incoming.isEmpty()) {
                return EMPTY_LONG_LIST;
            }
            TLongList result = this.incoming;
            this.incoming = null;
            return result;
        }
    }

    static final class BuilderDefaults {
        BuilderDefaults() {
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }

        public static AcexAnalyzer counterexampleAnalyzer() {
            return AcexAnalyzers.LINEAR_FWD;
        }
    }
}

