/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.kv.mealy;

import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.discriminationtree.DTNode;
import de.learnlib.discriminationtree.DiscriminationTree;
import de.learnlib.discriminationtree.MultiDTree;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.oracles.MQUtil;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.automata.transout.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class KearnsVaziraniMealy<I, O>
implements LearningAlgorithm.MealyLearner<I, O> {
    private static final TLongList EMPTY_LONG_LIST = new TLongArrayList(0);
    private final Alphabet<I> alphabet;
    private final CompactMealy<I, O> hypothesis;
    private final MembershipOracle<I, Word<O>> oracle;
    private final boolean repeatedCounterexampleEvaluation;
    private final DiscriminationTree<I, Word<O>, StateInfo<I, O>> discriminationTree;
    private final List<StateInfo<I, O>> stateInfos = new ArrayList<StateInfo<I, O>>();

    public KearnsVaziraniMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, boolean repeatedCounterexampleEvaluation) {
        this.alphabet = alphabet;
        this.hypothesis = new CompactMealy(alphabet);
        this.oracle = oracle;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
        this.discriminationTree = new MultiDTree(oracle);
    }

    public void startLearning() {
        this.initialize();
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        Word output;
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not initialized");
        }
        Word input = ceQuery.getInput();
        if (!this.refineHypothesisSingle(input, output = (Word)ceQuery.getOutput())) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(input, output)) {
            }
        }
        return true;
    }

    private boolean refineHypothesisSingle(Word<I> input, Word<O> output) {
        int inputLen = input.length();
        if (inputLen < 2) {
            return false;
        }
        int hypState = this.hypothesis.getInitialState();
        Iterator symIt = input.iterator();
        Object firstSym = symIt.next();
        hypState = (Integer)this.hypothesis.getSuccessor((Object)hypState, firstSym);
        Word prefix = Word.fromLetter(firstSym);
        Iterator outputIt = output.iterator();
        outputIt.next();
        int i = 2;
        while (symIt.hasNext()) {
            Object ceOutput;
            Word nextPrefix = input.prefix(i);
            Object sym = symIt.next();
            CompactMealyTransition trans = (CompactMealyTransition)this.hypothesis.getTransition(hypState, sym);
            Object hypOutput = this.hypothesis.getTransitionOutput(trans);
            if (!Objects.equals(hypOutput, ceOutput = outputIt.next())) {
                this.splitState(hypState, prefix, Word.fromLetter(sym), Word.fromLetter((Object)hypOutput), Word.fromLetter(ceOutput));
                return true;
            }
            int nextHypState = this.hypothesis.getIntSuccessor(trans);
            StateInfo<I, O> siftStateInfo = this.sift(nextPrefix);
            if (siftStateInfo.id != nextHypState) {
                this.updateTree(hypState, sym, nextHypState, siftStateInfo, hypOutput, prefix);
                return true;
            }
            hypState = nextHypState;
            prefix = nextPrefix;
            ++i;
        }
        return false;
    }

    private void splitState(int hypState, Word<I> newAs, Word<I> newDiscriminator, Word<O> oldOutcome, Word<O> newOutcome) {
        StateInfo<I, O> hypStateInfo = this.stateInfos.get(hypState);
        DTNode hypStateLeaf = hypStateInfo.dtNode;
        StateInfo<I, O> newStateInfo = this.createState(newAs);
        TLongList oldIncoming = hypStateInfo.fetchIncoming();
        DTNode.SplitResult split = hypStateLeaf.split(newDiscriminator, oldOutcome, newOutcome, newStateInfo);
        hypStateInfo.dtNode = split.nodeOld;
        newStateInfo.dtNode = split.nodeNew;
        this.initState(newStateInfo);
        this.updateTransitions(oldIncoming, hypStateLeaf);
    }

    private void updateTree(int hypState, I sym, int hypSucc, StateInfo<I, O> siftSucc, O transOut, Word<I> prefix) {
        DTNode<I, Word<O>, StateInfo<I, O>> hypSuccLeaf = this.dtNode(hypSucc);
        DTNode siftSuccLeaf = siftSucc.dtNode;
        DiscriminationTree.LCAInfo lcaInfo = this.discriminationTree.lcaInfo(hypSuccLeaf, siftSuccLeaf);
        DTNode separator = lcaInfo.leastCommonAncestor;
        Word<I> newDiscriminator = this.newDiscriminator(sym, separator.getDiscriminator());
        Word<O> oldStateOutcome = this.newOutcome(transOut, (Word)lcaInfo.subtree1Label);
        Word<O> newStateOutcome = this.newOutcome(transOut, (Word)lcaInfo.subtree2Label);
        this.splitState(hypState, prefix, newDiscriminator, oldStateOutcome, newStateOutcome);
    }

    private Word<O> newOutcome(O transOutput, Word<O> succOutcome) {
        return succOutcome.prepend(transOutput);
    }

    private void updateTransitions(TLongList transList, DTNode<I, Word<O>, StateInfo<I, O>> oldDtTarget) {
        int numTrans = transList.size();
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)(encodedTrans & 0xFFFFFFFFFFFFFFFFL);
            StateInfo<I, O> sourceInfo = this.stateInfos.get(sourceState);
            Object symbol = this.alphabet.getSymbol(transIdx);
            StateInfo<I, O> succInfo = this.sift(oldDtTarget, sourceInfo.accessSequence.append(symbol));
            Object output = ((CompactMealyTransition)this.hypothesis.getTransition(sourceState, transIdx)).getOutput();
            this.setTransition(sourceState, transIdx, succInfo, output);
        }
    }

    private Word<I> newDiscriminator(I symbol, Word<I> succDiscriminator) {
        return succDiscriminator.prepend(symbol);
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not started");
        }
        return this.hypothesis;
    }

    private StateInfo<I, O> createInitialState() {
        int state = this.hypothesis.addIntInitialState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, Word.epsilon());
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private StateInfo<I, O> createState(Word<I> prefix) {
        int state = this.hypothesis.addIntState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, prefix);
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private void initialize() {
        StateInfo<I, O> init = this.createInitialState();
        this.discriminationTree.getRoot().setData(init);
        init.dtNode = this.discriminationTree.getRoot();
        this.initState(init);
    }

    private void initState(StateInfo<I, O> stateInfo) {
        int alphabetSize = this.alphabet.size();
        int state = stateInfo.id;
        Word accessSequence = stateInfo.accessSequence;
        for (int i = 0; i < alphabetSize; ++i) {
            Object sym = this.alphabet.getSymbol(i);
            Object output = ((Word)MQUtil.output(this.oracle, accessSequence, (Word)Word.fromLetter((Object)sym))).firstSymbol();
            Word transAs = accessSequence.append(sym);
            StateInfo<I, O> succInfo = this.sift(transAs);
            this.setTransition(state, i, succInfo, output);
        }
    }

    private void setTransition(int state, int symIdx, StateInfo<I, O> succInfo, O output) {
        succInfo.addIncoming(state, symIdx);
        this.hypothesis.setTransition(state, symIdx, succInfo.id, output);
    }

    private DTNode<I, Word<O>, StateInfo<I, O>> dtNode(int state) {
        return this.stateInfos.get((int)state).dtNode;
    }

    private StateInfo<I, O> sift(Word<I> prefix) {
        return this.sift(this.discriminationTree.getRoot(), prefix);
    }

    private StateInfo<I, O> sift(DTNode<I, Word<O>, StateInfo<I, O>> start, Word<I> prefix) {
        DTNode leaf = this.discriminationTree.sift(start, prefix);
        StateInfo<I, O> succStateInfo = (StateInfo<I, O>)leaf.getData();
        if (succStateInfo == null) {
            succStateInfo = this.createState(prefix);
            leaf.setData(succStateInfo);
            succStateInfo.dtNode = leaf;
            this.initState(succStateInfo);
        }
        return succStateInfo;
    }

    private static final class StateInfo<I, O> {
        public final int id;
        public final Word<I> accessSequence;
        public DTNode<I, Word<O>, StateInfo<I, O>> dtNode;
        private TLongList incoming;

        public StateInfo(int id, Word<I> accessSequence) {
            this.accessSequence = accessSequence.trimmed();
            this.id = id;
        }

        public void addIncoming(int sourceState, int transIdx) {
            long encodedTrans = (long)sourceState << 32 | (long)transIdx;
            if (this.incoming == null) {
                this.incoming = new TLongArrayList();
            }
            this.incoming.add(encodedTrans);
        }

        public TLongList fetchIncoming() {
            if (this.incoming == null || this.incoming.isEmpty()) {
                return EMPTY_LONG_LIST;
            }
            TLongList result = this.incoming;
            this.incoming = null;
            return result;
        }
    }

    static final class BuilderDefaults {
        BuilderDefaults() {
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }
    }
}

