/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.example2;

import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandlers;
import de.learnlib.algorithms.lstargeneric.closing.ClosingStrategies;
import de.learnlib.algorithms.lstargeneric.mealy.ExtensibleLStarMealy;
import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.SUL;
import de.learnlib.cache.Caches;
import de.learnlib.drivers.reflect.AbstractMethodInput;
import de.learnlib.drivers.reflect.SimplePOJOTestDriver;
import de.learnlib.eqtests.basic.mealy.RandomWalkEQOracle;
import de.learnlib.experiments.Experiment;
import de.learnlib.oracles.ResetCounterSUL;
import de.learnlib.oracles.SULOracle;
import de.learnlib.statistics.SimpleProfiler;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Random;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.util.graphs.dot.GraphDOT;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class Example {
    public static void main(String[] args) throws NoSuchMethodException, IOException {
        ResetCounterSUL statisticSul;
        SimplePOJOTestDriver driver = new SimplePOJOTestDriver(BoundedStringQueue.class.getConstructor(new Class[0]), new Object[0]);
        Method mOffer = BoundedStringQueue.class.getMethod("offer", String.class);
        Method mPoll = BoundedStringQueue.class.getMethod("poll", new Class[0]);
        AbstractMethodInput offer_a = driver.addInput("offer_a", mOffer, new Object[]{"a"});
        AbstractMethodInput offer_b = driver.addInput("offer_b", mOffer, new Object[]{"b"});
        AbstractMethodInput poll = driver.addInput("poll", mPoll, new Object[0]);
        ResetCounterSUL effectiveSul = statisticSul = new ResetCounterSUL("membership queries", (SUL)driver);
        effectiveSul = Caches.createSULCache((Alphabet)driver.getInputs(), (SUL)effectiveSul);
        SULOracle mqOracle = new SULOracle((SUL)effectiveSul);
        ArrayList<Word> suffixes = new ArrayList<Word>();
        suffixes.add(Word.fromSymbols((Object[])new AbstractMethodInput[]{offer_a}));
        suffixes.add(Word.fromSymbols((Object[])new AbstractMethodInput[]{offer_b}));
        suffixes.add(Word.fromSymbols((Object[])new AbstractMethodInput[]{poll}));
        ExtensibleLStarMealy lstar = new ExtensibleLStarMealy(driver.getInputs(), (MembershipOracle)mqOracle, suffixes, ObservationTableCEXHandlers.CLASSIC_LSTAR, ClosingStrategies.CLOSE_FIRST);
        RandomWalkEQOracle randomWalks = new RandomWalkEQOracle(0.05, 10000L, false, new Random(46346293L), (SUL)driver);
        Experiment.MealyExperiment experiment = new Experiment.MealyExperiment((LearningAlgorithm)lstar, (EquivalenceOracle)randomWalks, driver.getInputs());
        experiment.setProfile(true);
        experiment.setLogModels(true);
        experiment.run();
        MealyMachine result = (MealyMachine)experiment.getFinalHypothesis();
        System.out.println("-------------------------------------------------------");
        System.out.println(SimpleProfiler.getResults());
        System.out.println(experiment.getRounds().getSummary());
        System.out.println(statisticSul.getStatisticalData().getSummary());
        System.out.println("States: " + result.size());
        System.out.println("Sigma: " + driver.getInputs().size());
        System.out.println();
        System.out.println("Model: ");
        GraphDOT.write((Automaton)result, (Collection)driver.getInputs(), (Appendable)System.out, (GraphDOTHelper[])new GraphDOTHelper[0]);
        Writer w = DOT.createDotWriter((boolean)true);
        GraphDOT.write((Automaton)result, (Collection)driver.getInputs(), (Appendable)w, (GraphDOTHelper[])new GraphDOTHelper[0]);
        w.close();
        System.out.println("-------------------------------------------------------");
    }

    public static class BoundedStringQueue {
        public static final int MAX_SIZE = 3;
        private Deque<String> data = new ArrayDeque<String>(3);

        public void offer(String s) {
            if (this.data.size() < 3) {
                this.data.offerFirst(s);
            }
        }

        public String poll() {
            return this.data.poll();
        }
    }
}

