/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.example3;

import com.google.common.base.Supplier;
import de.learnlib.algorithms.lstargeneric.mealy.ExtensibleLStarMealy;
import de.learnlib.algorithms.lstargeneric.mealy.ExtensibleLStarMealyBuilder;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.examples.example2.Example;
import de.learnlib.filters.reuse.ReuseCapableOracle;
import de.learnlib.filters.reuse.ReuseOracle;
import de.learnlib.filters.reuse.tree.SystemStateHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import net.automatalib.words.impl.SimpleAlphabet;

public class Example {
    private String offer1 = "offer_1";
    private String offer2 = "offer_2";
    private String poll = "poll";
    private Alphabet<String> sigma = new SimpleAlphabet();
    private List<Word<String>> initialSuffixes;

    public static void main(String[] args) throws Exception {
        Example example = new Example();
        System.out.println("--");
        System.out.println("Run experiment 1 (ReuseOracle):");
        MealyMachine<?, String, ?, String> result1 = example.runExperiment1();
        System.out.println("--");
        System.out.println("Run experiment 2:");
        MealyMachine<?, String, ?, String> result2 = example.runExperiment2();
        System.out.println("--");
        System.out.println("Model 1: " + result1.size() + " states");
        System.out.println("Model 2: " + result2.size() + " states");
        Word sepWord = null;
        sepWord = Automata.findSeparatingWord(result1, result2, example.sigma);
        System.out.println("Difference (separating word)? " + sepWord);
    }

    public Example() {
        this.sigma.add((Object)this.offer1);
        this.sigma.add((Object)this.offer2);
        this.sigma.add((Object)this.poll);
        this.initialSuffixes = new ArrayList<Word<String>>();
        for (String symbol : this.sigma) {
            this.initialSuffixes.add((Word<String>)Word.fromLetter((Object)symbol));
        }
    }

    public MealyMachine<?, String, ?, String> runExperiment1() throws Exception {
        FullMembershipQueryOracle oracle = new FullMembershipQueryOracle();
        ExtensibleLStarMealy lstar = null;
        lstar = new ExtensibleLStarMealyBuilder().withAlphabet(this.sigma).withInitialSuffixes(this.initialSuffixes).withOracle((MembershipOracle)oracle).create();
        lstar.startLearning();
        MealyMachine result = null;
        result = (MealyMachine)lstar.getHypothesisModel();
        System.out.println("Resets:  " + oracle.resets);
        System.out.println("Symbols: " + oracle.symbols);
        return result;
    }

    public MealyMachine<?, String, ?, String> runExperiment2() throws Exception {
        MySystemStateHandler ssh = new MySystemStateHandler();
        ReuseCapableImplFactory factory = new ReuseCapableImplFactory();
        ReuseOracle reuseOracle = new ReuseOracle.ReuseOracleBuilder(this.sigma, (Supplier)factory).withSystemStateHandler((SystemStateHandler)ssh).build();
        ExtensibleLStarMealy lstar = null;
        lstar = new ExtensibleLStarMealyBuilder().withAlphabet(this.sigma).withInitialSuffixes(this.initialSuffixes).withOracle((MembershipOracle)reuseOracle).create();
        lstar.startLearning();
        MealyMachine result = (MealyMachine)lstar.getHypothesisModel();
        reuseOracle.getReuseTree().disposeSystemstates();
        ReuseCapableImpl reuseCapableOracle = (ReuseCapableImpl)reuseOracle.getReuseCapableOracle();
        System.out.println("Resets:   " + reuseCapableOracle.fullQueries);
        System.out.println("Reused:   " + reuseCapableOracle.reused);
        System.out.println("Symbols:  " + reuseCapableOracle.symbols);
        System.out.println("Disposed: " + ssh.disposed);
        return result;
    }

    private String exec(Example.BoundedStringQueue s, String input) {
        if (input.equals(this.offer1) || input.equals(this.offer2)) {
            s.offer(input);
            return "void";
        }
        if (input.equals(this.poll)) {
            return s.poll();
        }
        throw new RuntimeException("unknown input symbol");
    }

    class ReuseCapableImpl
    implements ReuseCapableOracle<Example.BoundedStringQueue, String, String> {
        private int reused = 0;
        private int fullQueries = 0;
        private int symbols = 0;

        ReuseCapableImpl() {
        }

        public ReuseCapableOracle.QueryResult<Example.BoundedStringQueue, String> continueQuery(Word<String> trace, Example.BoundedStringQueue s) {
            ++this.reused;
            this.symbols += trace.size();
            WordBuilder output = new WordBuilder();
            for (String input : trace) {
                output.add((Object)Example.this.exec(s, input));
            }
            ReuseCapableOracle.QueryResult result = new ReuseCapableOracle.QueryResult(output.toWord(), (Object)s);
            return result;
        }

        public ReuseCapableOracle.QueryResult<Example.BoundedStringQueue, String> processQuery(Word<String> trace) {
            ++this.fullQueries;
            this.symbols += trace.size();
            Example.BoundedStringQueue s = new Example.BoundedStringQueue();
            WordBuilder output = new WordBuilder();
            for (String input : trace) {
                output.add((Object)Example.this.exec(s, input));
            }
            ReuseCapableOracle.QueryResult result = new ReuseCapableOracle.QueryResult(output.toWord(), (Object)s);
            return result;
        }
    }

    class ReuseCapableImplFactory
    implements Supplier<ReuseCapableOracle<Example.BoundedStringQueue, String, String>> {
        ReuseCapableImplFactory() {
        }

        public ReuseCapableOracle<Example.BoundedStringQueue, String, String> get() {
            return new ReuseCapableImpl();
        }
    }

    class FullMembershipQueryOracle
    implements MembershipOracle.MealyMembershipOracle<String, String> {
        private int resets = 0;
        private int symbols = 0;

        FullMembershipQueryOracle() {
        }

        public void processQueries(Collection<? extends Query<String, Word<String>>> queries) {
            for (Query<String, Word<String>> query : queries) {
                ++this.resets;
                this.symbols += query.getInput().size();
                Example.BoundedStringQueue s = new Example.BoundedStringQueue();
                WordBuilder output = new WordBuilder();
                for (String input : query.getInput()) {
                    output.add((Object)Example.this.exec(s, input));
                }
                query.answer((Object)output.toWord().suffix(query.getSuffix().size()));
            }
        }
    }

    class MySystemStateHandler
    implements SystemStateHandler<Example.BoundedStringQueue> {
        private int disposed = 0;

        MySystemStateHandler() {
        }

        public void dispose(Example.BoundedStringQueue state) {
            ++this.disposed;
        }
    }
}

