/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.example1;

import de.learnlib.algorithms.features.observationtable.OTUtils;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.features.observationtable.writer.ObservationTableASCIIWriter;
import de.learnlib.algorithms.lstargeneric.dfa.ExtensibleLStarDFA;
import de.learnlib.algorithms.lstargeneric.dfa.ExtensibleLStarDFABuilder;
import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.eqtests.basic.WMethodEQOracle;
import de.learnlib.experiments.Experiment;
import de.learnlib.oracles.CounterOracle;
import de.learnlib.oracles.SimulatorOracle;
import de.learnlib.statistics.SimpleProfiler;
import java.io.IOException;
import java.util.Collection;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.util.automata.builders.AutomatonBuilders;
import net.automatalib.util.graphs.dot.GraphDOT;
import net.automatalib.visualization.Visualization;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public class Example {
    private static CompactDFA<Character> constructSUL() {
        Alphabet sigma = Alphabets.characters((char)'a', (char)'b');
        CompactDFA dfa = (CompactDFA)AutomatonBuilders.newDFA((Alphabet)sigma).from((Object)"q0").on((Object)Character.valueOf('a')).to((Object)"q1").on((Object)Character.valueOf('b')).to((Object)"q2").from((Object)"q1").on((Object)Character.valueOf('a')).to((Object)"q0").on((Object)Character.valueOf('b')).to((Object)"q3").from((Object)"q2").on((Object)Character.valueOf('a')).to((Object)"q3").on((Object)Character.valueOf('b')).to((Object)"q0").from((Object)"q3").on((Object)Character.valueOf('a')).to((Object)"q2").on((Object)Character.valueOf('b')).to((Object)"q1").withInitial((Object)"q0").withAccepting((Object)"q0").create();
        return dfa;
    }

    public static void main(String[] args) throws IOException {
        CompactDFA<Character> target = Example.constructSUL();
        Alphabet inputs = target.getInputAlphabet();
        SimulatorOracle.DFASimulatorOracle sul = new SimulatorOracle.DFASimulatorOracle(target);
        CounterOracle.DFACounterOracle mqOracle = new CounterOracle.DFACounterOracle((MembershipOracle)sul, "membership queries");
        ExtensibleLStarDFA lstar = new ExtensibleLStarDFABuilder().withAlphabet(inputs).withOracle((MembershipOracle)mqOracle).create();
        WMethodEQOracle.DFAWMethodEQOracle wMethod = new WMethodEQOracle.DFAWMethodEQOracle(4, (MembershipOracle)mqOracle);
        Experiment.DFAExperiment experiment = new Experiment.DFAExperiment((LearningAlgorithm)lstar, (EquivalenceOracle)wMethod, inputs);
        experiment.setProfile(true);
        experiment.setLogModels(true);
        experiment.run();
        DFA result = (DFA)experiment.getFinalHypothesis();
        System.out.println("-------------------------------------------------------");
        System.out.println(SimpleProfiler.getResults());
        System.out.println(experiment.getRounds().getSummary());
        System.out.println(mqOracle.getStatisticalData().getSummary());
        System.out.println("States: " + result.size());
        System.out.println("Sigma: " + inputs.size());
        System.out.println();
        System.out.println("Model: ");
        GraphDOT.write((Automaton)result, (Collection)inputs, (Appendable)System.out, (GraphDOTHelper[])new GraphDOTHelper[0]);
        Visualization.visualizeAutomaton((Automaton)result, (Collection)inputs, (boolean)true, (GraphDOTHelper[])new GraphDOTHelper[0]);
        System.out.println("-------------------------------------------------------");
        System.out.println("Final observation table:");
        new ObservationTableASCIIWriter().write(lstar.getObservationTable(), System.out);
        OTUtils.displayHTMLInBrowser((ObservationTable)lstar.getObservationTable());
    }
}

