/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.automatalib.automaton.concept.Output;
import net.automatalib.common.util.collection.CollectionUtil;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class RandomWordsEQOracle<A extends Output<I, D>, I, D>
extends AbstractTestWordEQOracle<A, I, D> {
    private final Random random;
    private final int maxTests;
    private final int minLength;
    private final int maxLength;

    public RandomWordsEQOracle(MembershipOracle<I, D> mqOracle, int minLength, int maxLength, int maxTests) {
        this(mqOracle, minLength, maxLength, maxTests, new Random());
    }

    public RandomWordsEQOracle(MembershipOracle<I, D> mqOracle, int minLength, int maxLength, int maxTests, Random random) {
        this(mqOracle, minLength, maxLength, maxTests, random, 1);
    }

    public RandomWordsEQOracle(MembershipOracle<I, D> mqOracle, int minLength, int maxLength, int maxTests, Random random, int batchSize) {
        super(mqOracle, batchSize);
        this.maxTests = maxTests;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.random = random;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(A hypothesis, Collection<? extends I> inputs) {
        List symbolList = CollectionUtil.randomAccessList(inputs);
        return Stream.generate(() -> this.generateTestWord(symbolList, symbolList.size())).limit(this.maxTests);
    }

    private Word<I> generateTestWord(List<? extends I> symbolList, int numSyms) {
        int length = this.minLength + this.random.nextInt(this.maxLength - this.minLength + 1);
        WordBuilder result = new WordBuilder(length);
        for (int j = 0; j < length; ++j) {
            int symidx = this.random.nextInt(numSyms);
            I sym = symbolList.get(symidx);
            result.append(sym);
        }
        return result.toWord();
    }
}

