/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EQOracleChain<A, I, D>
implements EquivalenceOracle<A, I, D> {
    private final List<EquivalenceOracle<? super A, I, D>> oracles;

    @SafeVarargs
    public EQOracleChain(EquivalenceOracle<? super A, I, D> ... oracles) {
        this(Arrays.asList(oracles));
    }

    public EQOracleChain(List<? extends EquivalenceOracle<? super A, I, D>> oracles) {
        this.oracles = new ArrayList<EquivalenceOracle<A, I, D>>(oracles);
    }

    public void addOracle(EquivalenceOracle<? super A, I, D> oracle) {
        this.oracles.add(oracle);
    }

    public @Nullable DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        for (EquivalenceOracle<? super A, I, D> equivalenceOracle : this.oracles) {
            DefaultQuery ceQry = equivalenceOracle.findCounterExample(hypothesis, inputs);
            if (ceQry == null) continue;
            return ceQry;
        }
        return null;
    }
}

