/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.vpa;

import com.google.common.base.Preconditions;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Stream;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.concept.Output;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class RandomWellMatchedWordsEQOracle<I>
extends AbstractTestWordEQOracle<Output<I, Boolean>, I, Boolean> {
    private final Random random;
    private final double callProb;
    private final int maxTests;
    private final int minLength;
    private final int maxLength;

    public RandomWellMatchedWordsEQOracle(Random random, MembershipOracle<I, Boolean> oracle, double callProb, int maxTests, int minLength, int maxLength) {
        this(random, oracle, callProb, maxTests, minLength, maxLength, 1);
    }

    public RandomWellMatchedWordsEQOracle(Random random, MembershipOracle<I, Boolean> oracle, double callProb, int maxTests, int minLength, int maxLength, int batchSize) {
        super(oracle, batchSize);
        Preconditions.checkArgument((minLength <= maxLength ? 1 : 0) != 0, (Object)"minLength is smaller than maxLength");
        this.random = random;
        this.callProb = callProb;
        this.maxTests = maxTests;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(Output<I, Boolean> hypothesis, Collection<? extends I> inputs) {
        if (!(inputs instanceof VPAlphabet)) {
            throw new IllegalArgumentException("In order to generate well-matched words, a structured alphabet is required");
        }
        VPAlphabet alphabet = (VPAlphabet)inputs;
        int lengthRange = this.maxLength - this.minLength + 1;
        return Stream.generate(() -> this.generateWellMatched(alphabet, this.minLength + this.random.nextInt(lengthRange))).limit(this.maxTests);
    }

    private Word<I> generateWellMatched(VPAlphabet<I> alphabet, int len) {
        WordBuilder wb = new WordBuilder(len);
        this.generateWellMatched(wb, alphabet, len);
        return wb.toWord();
    }

    private void generateWellMatched(WordBuilder<I> wb, VPAlphabet<I> alphabet, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            wb.append(alphabet.getInternalSymbol(this.random.nextInt(alphabet.getNumInternals())));
            return;
        }
        double act = this.random.nextDouble();
        if (act < this.callProb) {
            boolean dir = this.random.nextBoolean();
            if (dir) {
                int cpos = this.random.nextInt(length - 1);
                this.generateWellMatched(wb, alphabet, cpos);
                wb.append(alphabet.getCallSymbol(this.random.nextInt(alphabet.getNumCalls())));
                int rpos = cpos + 1 + this.random.nextInt(length - cpos - 1);
                this.generateWellMatched(wb, alphabet, rpos - cpos - 1);
                wb.append(alphabet.getReturnSymbol(this.random.nextInt(alphabet.getNumReturns())));
                this.generateWellMatched(wb, alphabet, length - rpos - 1);
            } else {
                int rpos = 1 + this.random.nextInt(length - 1);
                int cpos = this.random.nextInt(rpos);
                this.generateWellMatched(wb, alphabet, cpos);
                wb.append(alphabet.getCallSymbol(this.random.nextInt(alphabet.getNumCalls())));
                this.generateWellMatched(wb, alphabet, rpos - cpos - 1);
                wb.append(alphabet.getReturnSymbol(this.random.nextInt(alphabet.getNumReturns())));
                this.generateWellMatched(wb, alphabet, length - rpos - 1);
            }
        } else {
            int sep = 1 + this.random.nextInt(length - 1);
            this.generateWellMatched(wb, alphabet, sep);
            this.generateWellMatched(wb, alphabet, length - sep);
        }
    }
}

