/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.spmm;

import com.google.common.collect.Streams;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SPMM;
import net.automatalib.util.automaton.conformance.SPMMWMethodTestsIterator;
import net.automatalib.word.Word;

public class WMethodEQOracle<I, O>
extends AbstractTestWordEQOracle<SPMM<?, I, ?, O>, I, Word<O>> {
    private final int lookahead;
    private final int expectedSize;

    public WMethodEQOracle(MembershipOracle<I, Word<O>> sulOracle, int lookahead) {
        this(sulOracle, lookahead, 0);
    }

    public WMethodEQOracle(MembershipOracle<I, Word<O>> sulOracle, int lookahead, int expectedSize) {
        this(sulOracle, lookahead, expectedSize, 1);
    }

    public WMethodEQOracle(MembershipOracle<I, Word<O>> sulOracle, int lookahead, int expectedSize, int batchSize) {
        super(sulOracle, batchSize);
        this.lookahead = lookahead;
        this.expectedSize = expectedSize;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(SPMM<?, I, ?, O> hypothesis, Collection<? extends I> inputs) {
        if (!(inputs instanceof ProceduralInputAlphabet)) {
            throw new IllegalArgumentException("Inputs are not a procedural alphabet");
        }
        ProceduralInputAlphabet alphabet = (ProceduralInputAlphabet)inputs;
        return Streams.stream((Iterator)new SPMMWMethodTestsIterator(hypothesis, alphabet, Math.max(this.lookahead, this.expectedSize - hypothesis.size())));
    }
}

